unit ufields;

{$mode delphi}

interface

uses
  Classes, SysUtils,
  ufechas,
  uauxiliares,
  xmatdefs, matreal, MatEnt;

type

  { TField }
  TField = class
    valstr: string;
    function AsString: string;
    function AsDateTime(def: TDateTime = 0): TDateTime;
    function AsInteger(def: integer = 0): integer;
    function AsFloat(def: NReal = 0.0): NReal;
    function AsBoolean(def: boolean = False): boolean;
    function AsDAOfString: TDAOfString;
    function AsDAOfDateTime: TDAOfDateTime;
    function AsVectR: TVectR;
    function AsMatR: TMatR;
    function AsVectE: TVectE;
    function AsMatE: TMatE;
    constructor Create(valstr: string);
  end;



implementation


function TField.AsString: string;
begin
  Result := ValStr;
end;

function TField.AsDateTime(def: TDateTime = 0): TDateTime;
begin
  if valstr <> '' then
    Result := ufechas.IsoStrToDateTime(valstr)
  else
    Result := def;
end;

function TField.AsInteger(def: integer): integer;
begin
  if valstr <> '' then
    Result := StrToInt(valstr)
  else
    Result := def;
end;

function TField.AsFloat(def: NReal): NReal;
begin
  if valstr <> '' then
    Result := StrToFloat(valstr)
  else
    Result := def;
end;

function TField.AsBoolean(def: boolean): boolean;
begin
  if valstr <> '' then
    Result := self.valstr[1] in ['T', 't', 'v', 'V', '1', 'S', 's']
  else
    Result := def;
end;

function TField.AsDAOfString: TDAOfString;
var
  s, pal: string;
  cnt: integer;
  res: TDAOfString;
begin
  s := trim(valstr);
  Delete(s, 1, 1);
  Delete(s, length(s), 1);
  cnt := ContarCaracter(s, ',') + 1;
  setlength(res, cnt);
  for cnt := 0 to cnt - 1 do
  begin
    getPalHastaSep(pal, s, ',');
    res[cnt] := pal;
  end;
  Result := res;
end;

function TField.AsDAOfDateTime: TDAOfDateTime;
var
  s, pal: string;
  cnt: integer;
  res: TDAOfDateTime;
  k: integer;
begin
  s := trim(valstr);
  cnt := ContarCaracter(s, ',') + 1;
  setlength(res, cnt);
  k := 0;
  while nextPalEntreEstricto(pal, s, '"', '"') do
  begin
    res[k] := ufechas.IsoStrToDateTime(pal);
    Inc(k);
  end;
  Result := res;
end;


function TField.AsVectR: TVectR;
var
  res: TVectR;
begin
  res := TVectR.Create_unserialize_pg(valstr);
  Result := res;
end;

function TField.AsMatR: TMatR;
var
  res: TMatR;
begin
  res := TMatR.Create_unserialize_pg(valstr);
  Result := res;
end;

function TField.AsVectE: TVectE;
var
  res: TVectE;
begin
  res := TVectE.Create_unserialize_pg(valstr);
  Result := res;
end;

function TField.AsMatE: TMatE;
var
  res: TMatE;
begin
  res := TMatE.Create_unserialize_pg(valstr);
  Result := res;
end;


constructor TField.Create(valstr: string);
begin
  self.valstr := valstr;
end;


end.

