unit umodelos;
{
En esta unidad se define la clase TModelo. El proposito es dar un marco para
poder cargar y evaluar una relacion de entre dos conjuntos de series temporales
compatible con el formato de la clase TSeriesDeDatos

}
{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, useriestemporales,xmatdefs,matreal,MatEnt;


type

  { TModelo }

  TModelo = class
    cntParams,cntParamsR,cntParamsN:integer; // cantidad de parametros, reales y enteros
    cntEntradas,cntEntradasR,cntEntradasN,cntSalidas,cntSalidasR,cntSalidasN:integer; // cantidad de entradas
    series:TSeriesDeDatos; // series que definen la relacion
    entradasR,salidasR:TDAOfVectR; // entradas y salidas reales
    entradasN,salidasN:TDAOfVectE; // entradas y salidas enteras
    entradasRCalculadas,salidasRCalculadas:TDAOfVectR; // entradas y salidas reales calculadas
    entradasNCalculadas,salidasNCalculadas:TDAOfVectE; // entradas y salidas enteras calculadas
    datosNoValidos:TStringList; // datos para los cuales no se evalua


    constructor Create(xSeries:TSeriesDeDatos;xDatosNoValidos:TStringList);

    // salidasCalculadas <--- f(entradas) donde f es el modelo
    procedure evaluarModelo();
    procedure evaluarMuestra(kMuestra:integer);
    function calcularError:NReal;
    function calcularErrorCuadraticoMedio:NReal;

  end;


implementation

{ TModelo }

constructor TModelo.Create(xSeries: TSeriesDeDatos; xDatosNoValidos: TStringList
  );
begin
  series:=xSeries;
  datosNoValidos:=xDatosNoValidos;
end;

procedure TModelo.evaluarModelo();
var
  kMuestra,NMuestras:integer;
begin
  for kMuestra:=0 to NMuestras - 1 do
    evaluarMuestra(kMuestra);
end;

procedure TModelo.evaluarMuestra(kMuestra: integer);
begin

end;

function TModelo.calcularError: NReal;
begin

end;

function TModelo.calcularErrorCuadraticoMedio: NReal;
begin

end;

end.

