#!/bin/bash
# Compila todos los proyectos

raiz=${PWD}
lazarus='/usr/bin'
resultados=${HOME}'/SimSEE/SimSEE_src'

carpeta='ap/SimRes3'
lpi='SimRes3'
bm='--bm=Release'


function build
{	

${lazarus}/lazbuild -B ${bm} ${raiz}/${carpeta}/${lpi}.lpi > ${resultados}/${lpi}_mkres.txt
rm -f ${resultados}/${lpi}_ERROR.txt

if [ $? -eq 0 ]
then
  echo "ERROR ${$?}" > ${resultados}/${lpi}_ERROR.txt
else
  echo "RES: ${$?}"
fi

}

carpeta="ap/SimRes3"
lpi='SimRes3'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)

carpeta='ap/SimRes3'
lpi='SimRes3'
bm='--bm=SinExcel'
echo "building .. ${lpi}"
echo $(build)

carpeta='ap/SimRes3'
lpi='cmdsimres3'
bm=''
echo "building .. ${lpi}"
echo $(build)


carpeta='ap/editor'
lpi='SimSEEEdit'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)


carpeta='ap/optsim'
lpi='SimSEESimulador'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)


carpeta='ax/testSimplex'
lpi='testSimplex'
bm=''
echo "building .. ${lpi}"
echo $(build)


carpeta='ax/DatosBin2XLT'
lpi='datosbin2xlt'
bm=''
echo "building .. ${lpi}"
echo $(build)

carpeta='ap/cmdopt'
lpi='cmdopt'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)


carpeta='ap/cmdsim'
lpi='cmdsim'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)


carpeta='ax/analisisserial'
lpi='analisisserial'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)


carpeta='oddface/prepare'
lpi='oddface_prepare'
bm='--bm=Default'
echo "building .. ${lpi}"
echo $(build)

carpeta='oddface/pig'
lpi='oddface_pig'
bm='--bm=Release'
echo "building .. ${lpi}"
echo $(build)

