unit uoddface_roscon_cfg;

{$mode delphi}
interface
// Esta unidad define la configuraciónd e conexión de los demonios de OddFace
// por defecto se suministra una configuración que no es operativa y debe
// sustituirse por la configuración que corresponda en cada caso.
uses
  Classes, SysUtils,
  urosx;

var
  dbcon_rosx: TDBrosxCon;


implementation

var
  ipfija_rosx: string; // si se inicializa no se consulta la ip
  host_rosx: string; // se usa si ipfija='' para buscar la ip
  puerto_rosx: string; // por defecto es 80
  uri_rosx: string; // Por ej: '/simsee/ros/rosx.php';

  {$IFDEF PROXY_ENABLED_ROS}
  // se usan solo si está en modo  PROXY_ENABLED_ROS
   proxy_host, proxy_port, proxy_user, proxy_pass: string;
  {$ENDIF}



initialization

ipfija_rosx:= '';
host_rosx:='';
puerto_rosx:='';
uri_rosx:='';
{$IFDEF PROXY_ENABLED_ROS}
 proxy_host:= '';
 proxy_port:= '';
 proxy_user:= '';
 proxy_pass:= '';
{$ENDIF}


{$I oddface_rosx.cfg}

writeln( 'uoddface_roscon_cfg' );
writeln( 'ipfija_rosx: ', ipfija_rosx );
writeln( 'host_rosx: ', host_rosx );
writeln( 'puerto_rosx: ', puerto_rosx  );
writeln( 'uri_rosx: ', uri_rosx );


dbcon_rosx := TDBrosxCon.Create(ipfija_rosx, host_rosx, puerto_rosx, uri_rosx);
{$IFDEF PROXY_ENABLED_ROS}
  // se usan solo si está en modo  PROXY_ENABLED_ROS
 dbcon_rosx.proxy_host:= proxy_host;
 dbcon_rosx.proxy_port:= proxy_port;
 dbcon_rosx.proxy_user:= proxy_user;
 dbcon_rosx.proxy_pass:= proxy_pass;
 {$ENDIF}

dbcon_rosx.determinar_tipo_servidor;


finalization
  if dbcon_rosx <> nil then
    dbcon_rosx.Free;
end.
