unit uoddfaceconfig;

{$mode delphi}

interface

uses
  Classes, SysUtils, urosx, uConstantesSimSEE;

const
  VERSION_ODDFACE_CONFIG = 2;

type

  { TOddFaceConfigRec }
 TOddFaceConfigRec = class
   Version: integer;

   UsuarioSimSEE: string;
   ClaveSimSEE: string;
   ros_ip: string;
   ros_host: string;
   ros_port: string;
   ros_uri: string; // uri a la rosx
   proxy_host: string;
   proxy_port: string;
   proxy_user: string;
   proxy_pass: string;
   flg_recordar_clave_proxy: boolean;
   flg_recordar_clave_simsee: boolean;

   // Guarda la configuración
   procedure Save;

   // no use estas funciones, en lugar de ello use get_oddface_cfg
   constructor CreateLoad;
   constructor CreateEmpty;

 end;



 // Si aún no fue leida/creada la lee o la crea y retorna puntero.
function get_OddFace_cfg: TOddFaceConfigRec;


implementation

var
  oddface_cfg: TOddFaceConfigRec;

  // Si aún no fue leida/creada la lee o la crea y retorna puntero.
function get_OddFace_cfg: TOddFaceConfigRec;
begin
  if oddface_cfg = nil then
    oddface_cfg:= TOddFaceConfigRec.CreateLoad;
  result:= oddface_cfg;
end;


function archi_oddface_cfg: string;
begin
  result:= getDir_Bin+'oddface.cfg'
end;

{ TOddFaceConfigRec }

constructor TOddFaceConfigRec.CreateLoad;
var
  fconfig: textfile;
  pal: string;
  archi: string;
  OldFileMode: integer;

function getpal: string;
begin
  if not eof( fconfig ) then
  begin
    readln( fconfig, pal );
    result:= desbarullar( pal )
  end
  else
    result:= '';
end;

begin
  CreateEmpty;
  archi := archi_oddface_cfg;
  if fileexists( archi ) then
  try
    OldFileMode:= filemode;
    filemode:= 0;
    assignfile( fconfig, archi );
    reset( fconfig );
    readln( fconfig, pal ); // versión del archivo
    version:= StrToInt( pal );
    UsuarioSimSEE:= getpal;
    ClaveSimSEE:= getpal;
    if version >= 2 then
    begin
      ros_ip:= getpal;
      ros_host:= getpal;
      ros_port:= getpal;
      ros_uri:= getpal;
    end;
    proxy_host:= getpal;
    proxy_port:= getpal;
    proxy_user:= getpal;
    proxy_pass:= getpal;
    flg_recordar_clave_proxy:= getpal = '1';
    flg_recordar_clave_simsee:= getpal = '1';
    closefile( fconfig );
  except
    // nada
  end;
  fileMode:= OldFileMode;
end;

//   'iie.fing.edu.uy', 80, '/simsee/ros/rosx.php'
//   'latorre.adme.com.uy', 80, '/zeros/x/rosx.php'

constructor TOddFaceConfigRec.CreateEmpty;
begin
  UsuarioSimSEE:= '';
  ClaveSimSEE:= '';
  ros_ip:= '';
  ros_host:= 'latorre.adme.com.uy';
  ros_port:= '80';
  ros_uri:= '/zeros/x/rosx.php';
  proxy_host:= '';
  proxy_port:= '';
  proxy_user:= '';
  proxy_pass:= '';
  flg_recordar_clave_proxy:= false;
  flg_recordar_clave_simsee:= false;
end;

procedure TOddFaceConfigRec.Save;
var
  OldFileMode: integer;
  fconfig: textfile;
  pal: string;

begin
  OldFileMode:= fileMode;
  filemode:= 1;
  try
  assignfile( fconfig, archi_oddface_cfg );
  rewrite( fconfig );
  writeln( fconfig, VERSION_ODDFACE_CONFIG); // versión del archivo
  writeln( fconfig, barullar( UsuarioSimSEE ));
  if flg_recordar_clave_simsee then
   writeln( fconfig, barullar( ClaveSimSEE ))
  else
   writeln( fconfig, '' );

  writeln( fconfig, barullar( ros_ip ));
  writeln( fconfig, barullar( ros_host ));
  writeln( fconfig, barullar( ros_port ));
  writeln( fconfig, barullar( ros_uri ));

  writeln( fconfig, barullar( proxy_host ));
  writeln( fconfig, barullar( proxy_port ));
  writeln( fconfig, barullar( proxy_user ));
  if flg_recordar_clave_proxy then
   writeln( fconfig, barullar( proxy_pass ))
  else
   writeln( fconfig, '');

  if flg_recordar_clave_proxy then
    writeln( fconfig, barullar( '1' ) )
  else
   writeln( fconfig, barullar( '0' ) );

  if flg_recordar_clave_simsee then
    writeln( fconfig, barullar( '1' ) )
  else
    writeln( fconfig, barullar( '0' ) );

  closefile( fconfig );

  finally
    filemode:= OldFileMode;
  end;
end;

initialization
  oddface_cfg:= nil;

finalization
  if oddface_cfg <> nil then
  begin
   oddface_cfg.Free;
   oddface_cfg:= nil;
  end;
end.

