program oddface_OptimA;
uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes,
  xmatdefs,
  uoddface_OptimA,
  uConstantesSimSEE,
  uoddface_roscon_cfg, uFuenteSintetizador, interfaces,
  sysutils;



var
 idEjecutor: string;
 idProblema: integer;
 idNodo: integer;
 problema: TOptimA_Problema;
 res: integer;
 nidIndividuo: Integer;
 archiSala: string;
 MontoInversiones: NReal;


begin
  SetLength(TrueBoolStrs,1);
  SetLength(FalseBoolStrs,1);
  TrueBoolStrs[0]:='1';
  FalseBoolStrs[0]:='0';

  if ParamCount < 2 then
  begin
    writeln( 'Debe pasar por lo menos dos parametros para identificacion del Ejecutor y el Problema' );
    exit;
  end;
  idEjecutor:= paramStr( 1 );


  idProblema:= StrToInt(ParamStr( 2 ) );

  if ParamCount < 3 then
    idNodo:= 0 // el cluster
  else
    idNodo:= StrToInt( paramStr( 3 ) );


  tmp_rundir := CrearDirectorioTemporal(getDefault_tmp_base, idEjecutor);

  if tmp_rundir <> '' then
    limpiarCarpeta(tmp_rundir, '*.*');

  writeln('Cambiando el directorio a : ', tmp_rundir);
  chdir(tmp_rundir);


  // si idNodo = -1 crea la sala cuyo NID es ParamStr(4) y NO Simula y se va sin eliminar los archivos.
  // sirve para bajar un caso de la base del servidor.
  // Si idNodo >= 0 hay que simular. En Ese caso, si existe ParamStr(4) es la cantidad de hilos
  // a abrir.
  problema:= TOptimA_Problema.CreateFromDB( dbcon_rosx, idProblema, StrToInt(idEjecutor), tmp_rundir );
  if problema =  nil then
    raise Exception.Create( 'No fue posible crear el problema.' );
  writeln('Cambiando el directorio a : ',tmp_rundir );
  chdir( tmp_rundir );

  if idNodo >= 0 then
  begin
//    randomize;
    res:= problema.Explorar;
  end
  else
  begin
    nidIndividuo:= StrToInt( ParamStr( 4 ) );
    if nidIndividuo >=  0 then
    begin
      archiSala := problema.BajarCrearSalaSimSEE(nidIndividuo, MontoInversiones);
      writeln( 'Sala creada, NID: ', nidIndividuo,', archivo: ', archiSala );
      writeln( 'MontoInversiones a sumar [MUSD]: ', MontoInversiones:12:3 );
    end;
    writeln( '.... PRESIONE ENTER PARA CONTINUAR...' );
    readln;
  end;

  problema.Free;

  if idNodo >= 0 then
  begin
    writeln( 'Cantidad de evaluaciones realizadas: ', res );

    if tmp_rundir <> '' then
    begin
      limpiarCarpeta( tmp_rundir, '*.*' );
      removeDir( tmp_rundir );
    end;
  end;

end.

