program oddface_pdet;
{$mode delphi}
uses
{$H+}
{$IFDEF UNIX}{$IFDEF UseCThreads}
cthreads,
{$ENDIF}{$ENDIF}
Classes,
uConstantesSimSEE, uInicioYFinal, uActores, uDataSetGenerico,
usimplex, urosx,
u_updownload,
uempaquetar, ucontroladordeterminista,
uoddface_pdet,
sysutils;

var
idEjecutor: string;
idProblema: integer;
idNodo: integer;
problema: TPDET_Problema;
res: integer;
nidIndividuo: Integer;
archiSala: string;

begin
SetLength(TrueBoolStrs,1);
SetLength(FalseBoolStrs,1);
TrueBoolStrs[0]:='1';
FalseBoolStrs[0]:='0';

if ParamCount < 2 then
begin
  writeln( 'Debe pasar por lo menos dos parametros para identificacion del Ejecutor y el Problema' );
  exit;
end;
idEjecutor:= paramStr( 1 );

idProblema:= StrToInt(ParamStr( 2 ) );

if ParamCount < 3 then
  idNodo:= 0 // el cluster
else
  idNodo:= StrToInt( paramStr( 3 ) );



{$IFDEF LINUX}
tmp_rundir:= '/tmp/simsee/'+idEjecutor;
if not DirectoryExists ( '/tmp/simsee' ) then CreateDir( '/tmp/simsee' );
if not DirectoryExists ( tmp_rundir ) then CreateDir( tmp_rundir );
{$ELSE}
tmp_rundir:= '\simsee\tmp_rundir\'+idEjecutor;
if not DirectoryExists ( '\simsee\tmp_rundir' ) then CreateDir( '\simsee\tmp_rundir' );
if not DirectoryExists ( tmp_rundir ) then CreateDir( tmp_rundir );
{$ENDIF}

if tmp_rundir <> '' then
  limpiarCarpeta( tmp_rundir, '*.*' );

writeln('Cambiando el directorio a : ',tmp_rundir );
chdir( tmp_rundir );

problema:= TPAM_Problema.CreateFromDB( idProblema, StrToInt(idEjecutor), tmp_rundir );
if problema =  nil then
  raise Exception.Create( 'No fue posible crear el problema.' );

if idNodo >= 0 then
begin
  randomize;
  res:= problema.Explorar;
end
else
begin
  nidIndividuo:= StrToInt( ParamStr( 4 ) );
  archiSala:= problema.BajarCrearSalaSimSEE( nidIndividuo );
  writeln( 'Sala creada, NID: ', nidIndividuo,', archivo: ', archiSala );
  readln;
end;

problema.Free;

if idNodo >= 0 then
begin
  writeln( 'Cantidad de evaluaciones realizadas: ', res );
  if tmp_rundir <> '' then
  begin
    limpiarCarpeta( tmp_rundir, '*.*' );
    removeDir( tmp_rundir );
  end;
end;
end.

