program oddface_pig;

{xDEFINE SALTEAR_BAJAR_SALA}

uses {$IFDEF UNIX} {$IFDEF UseCThreads}
  cthreads, {$ENDIF} {$ENDIF}
  Classes,
  uConstantesSimSEE,
  uInicioYFinal,
  uDataSetGenerico,
  xmatdefs,
  uoddface,
  uoddface_pig,
  usimplex,
  urosx,
  u_updownload,
  usalasdejuego,
  uRobotHttpPost,
  uLectorSimRes3Defs,
  uAuxiliaresEscrituraSimRes,
  uPrint,
  httpsend,
  SysUtils,
  uoddface_roscon_cfg;
var
  idEjecutor: string;
  idProblema: integer;
  idNodo: integer;
  problema: TPIG_Problema;
  res: integer;
  nidIndividuo: integer;
  archiSala: string;
  MontoInversiones: NReal;
  aIndividuo: TIndividuo;

begin
  SetLength(TrueBoolStrs, 1);
  SetLength(FalseBoolStrs, 1);
  TrueBoolStrs[0] := '1';
  FalseBoolStrs[0] := '0';

  if ParamCount < 2 then
  begin
    writeln('Debe pasar por lo menos dos parametros para identificacion del Ejecutor y el Problema'
      );
    exit;
  end;
  idEjecutor := ParamStr(1);

  idProblema := StrToInt(ParamStr(2));

  if ParamCount < 3 then
    idNodo := 0 // el cluster
  else
    idNodo := StrToInt(ParamStr(3));

  // si idNodo = -1 crea la sala cuyo NID es ParamStr(4) y NO Simula y se va sin eliminar los archivos.
  // sirve para bajar un caso de la base del servidor.

  tmp_rundir := CrearDirectorioTemporal(getDefault_tmp_base, idEjecutor);


  {$IFDEF SALTEAR_BAJAR_SALA}
  flg_BAJAR_SALA := False;
  {$ENDIF}

  if (tmp_rundir <> '') and flg_BAJAR_SALA then
    limpiarCarpeta(tmp_rundir, '*.*');

  writeln('Cambiando el directorio a : ', tmp_rundir);
  chdir(tmp_rundir);

  problema := TPIG_Problema.CreateFromDB( dbcon_rosx, idProblema,
    StrToInt(idEjecutor), tmp_rundir);
  if problema = nil then
    raise Exception.Create('No fue posible crear el problema.');

  if idNodo >= 0 then
  begin
    system.randomize;
    res := problema.Explorar;
  end
  else
  begin
    nidIndividuo := StrToInt(ParamStr(4));
    archiSala := problema.BajarCrearSalaSimSEE(nidIndividuo, aIndividuo, MontoInversiones);
    writeln('Sala creada, NID: ', nidIndividuo, ', archivo: ', archiSala);
    writeln('MontoInversiones a sumar [MUSD]: ', MontoInversiones: 12: 3);
    if idNodo = -2 then
      problema.evaluar_( aIndividuo, 31 );

    aIndividuo.Free;
  end;

  problema.Free;


  if idNodo >= 0 then
  begin
    writeln('Cantidad de evaluaciones realizadas: ', res);

    if tmp_rundir <> '' then
    begin
      limpiarCarpeta(tmp_rundir, '*.*');
      removeDir(tmp_rundir);
    end;
  end;

end.
