unit u_editorproblema;

{$mode delphi}

interface

uses
  Classes, SysUtils, FileUtil,
  Forms,
  Controls,
  Graphics, Dialogs,
  StdCtrls,
  //ExtCtrls,
  uDataSetGenerico,
  unotificar,
  urosx,
  uauxiliares,
  uempaquetar,
  u_pig_editortecnologias,
  u_pam_editorordenes,
  u_updownload,
  u_optima_editorinfo,
  usalasdejuego,
  ucosa,
  uform_textarea;

type

  { TForm_EditorProblema }

  TForm_EditorProblema = class(TForm)
    btUpdate: TButton;
    bt_BuscarSala: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    btBorrarHistorial: TButton;
    btRefrescar: TButton;
    btBajar: TButton;
    cbTipos: TComboBox;
    e_ro_fosil_agosto2011: TEdit;
    e_ro_binary: TEdit;
    e_ro_gray: TEdit;
    e_ro_unary: TEdit;
    e_dias_por_etapa: TEdit;
    e_n_etapas: TEdit;
    e_fecha_primer_etapa: TEdit;
    eNID_Problema: TEdit;
    e_descripcion: TMemo;
    e_dtCreacion: TEdit;
    e_GA_prob_mutacion: TEdit;
    e_GA_prob_premio_exito: TEdit;
    e_N_CronicasPorVez: TEdit;
    e_N_DiscretizacionHistograma: TEdit;
    e_ro_CVaR: TEdit;
    e_ro_EG: TEdit;
    e_ro_GA: TEdit;
    e_ro_MJ: TEdit;
    e_ro_VaR: TEdit;
    e_ro_VE: TEdit;
    e_sala_simsee: TEdit;
    e_semilla_madre: TEdit;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label2: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    lbl_cnt_evaluaciones: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    OpenDialog1: TOpenDialog;
    procedure btBajarClick(Sender: TObject);
    procedure btBorrarHistorialClick(Sender: TObject);
    procedure btRefrescarClick(Sender: TObject);
    procedure btUpdateClick(Sender: TObject);
    procedure bt_BuscarSalaClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure e_ro_binaryChange(Sender: TObject);
    private
    { private declarations }
  public
    { public declarations }
    nid_tipos: array of integer;
    dbcon: TDBrosxCon;
    procedure LoadRec(nid: integer);
    procedure writeToRec;
    constructor Create( TheOwner: TComponent; dbconx: TDBrosxCon );
  end;

var
  Form_EditorProblema: TForm_EditorProblema;

implementation

{$R *.lfm}



function crear_carpeta(dbcon: TDBrosxCon; nid_problema: integer; tipo: integer;
  CarpetaLocal, descripcion: string): integer;
var
  cnt: integer;
begin
  cnt := StrToInt( dbcon.sql_func(
    'SELECT count(*) FROM ofe_carpetas WHERE nid = ' + IntToStr(nid_problema) + ' LIMIT 1'));
  if cnt = 0 then
  begin
    dbcon.sql_exec('INSERT INTO ofe_carpetas ( nid, fecha, tipo, path, descripcion ) VALUES ('
      + IntToStr(nid_problema) + ', now(), ' + IntToStr(
      tipo) + ', ''' + CarpetaLocal + ''', ''' + Descripcion + ''' ) ');
  end
  else
  begin
    dbcon.sql_exec('UPDATE ofe_carpetas SET fecha = now(), tipo = ' + IntToStr(
      tipo) + ', path=''' + CarpetaLocal + ''', descripcion=''' +
      descripcion + ''' WHERE nid = ' + IntToStr(nid_problema));
  end;
  Result := nid_problema;
end;




{ TForm_EditorProblema }

procedure TForm_EditorProblema.btUpdateClick(Sender: TObject);
begin
  WriteToRec;
  ModalResult := 1;
end;

procedure TForm_EditorProblema.btBorrarHistorialClick(Sender: TObject);
var
  res: string;
begin
  res:= unotificar.confirmar('Está seguro que quiere elminiar todas las evaluaciones de este problema', ['Si', 'No'] );
  if res = 'Si' then
  begin
    if dbcon.sql_exec( 'DELETE FROM ofe_individuos_'+eNID_Problema.Text ) then
      notificar( 'Eliminación exitosa.' )
    else
      notificar( 'Oucurrió un error al intentar eliminar los individuos.', true );
  end
  else
    notificar( 'Eliminación cancelada' );
end;

procedure TForm_EditorProblema.btBajarClick(Sender: TObject);
var
  oddface_tmpdir : string;
  nid_problema: integer;

begin
  oddface_tmpdir := 'oddface_tmpdir';
  if not DirectoryExists( oddface_tmpdir ) then
    CreateDir( oddface_tmpdir );

  nid_Problema:= StrToInt(eNID_Problema.Text);
  oddface_tmpdir := oddface_tmpdir+DirectorySeparator+IntToStr( nid_Problema ) ;
  if not DirectoryExists( oddface_tmpdir ) then
    CreateDir( oddface_tmpdir );

  unotificar.esperando_inicio('bajando archivos en; '+ oddface_tmpdir );
  u_updownload.bajarCarpeta( dbcon, 'ofe_carpetas', 'ofe_archivos', NID_Problema, oddface_tmpdir);
  unotificar.esperando_fin;
end;


procedure TForm_EditorProblema.btRefrescarClick(Sender: TObject);
begin
 lbl_cnt_evaluaciones.Caption:= dbcon.sql_func( 'SELECT sum(cnt_evaluaciones) FROM ofe_individuos_'+eNID_Problema.Text );
end;

procedure TForm_EditorProblema.bt_BuscarSalaClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Sala SimSEE|*.ese|Series de datos|*.txt;*.xlt';
  if OpenDialog1.Execute then
  begin
    e_sala_simsee.Text := OpenDialog1.FileName;
  end;
end;

procedure TForm_EditorProblema.Button1Click(Sender: TObject);
var
  carpeta: string;
  nid_carpeta: integer;
  zipname: string;
  res: integer;
  ext_str: string;
  lstArchis: TStringList;
  salaDummy:TSalaDeJuego;
  f:TarchiTexto;
  Catalogo:TCatalogo;
  b:boolean;


begin
  if not FileExists(e_sala_simsee.Text) then
    unotificar.notificar('No se encuentra el archivo de sala: ' + e_sala_simsee.Text, true)
  else
  begin
    ext_str:= ExtractFileExt( e_sala_simsee.Text );
    if ext_str = '.ese' then
    begin
      b :=False;
      f := TArchiTexto.CreateForRead(0, Catalogo, e_sala_simsee.Text, False);
      salaDummy :=TSalaDeJuego.Create_ReadFromText(f);
      zipname := uempaquetar.EmpaquetarSalaEnZip(salaDummy, nil, b);
      salaDummy.Free;
    end
    else
    begin
      lstArchis:= TStringList.Create;
      lstArchis.add( e_sala_simsee.Text );
      zipname:= ChangeFileExt( e_sala_simsee.Text, '' );
      if ext_str <> '.zip' then
      begin
        if FileExists( zipName+'.zip' ) then
          deletefile( zipName+'.zip' );
      end;
      if zipearListaDeArchivos( lstArchis, zipName ) <> 1 then
         raise Exception.Create('No fue posible comprimir el archivo.' );
      zipname:= zipname+'.zip';
    end;

    nid_carpeta := crear_carpeta(dbcon, StrToInt(eNID_Problema.Text), 1,
      'ofe_' + eNID_Problema.Text, 'Datos sala SimSEE.');

    // si habia algo lo borro.
    clear_carpeta( dbcon, 'ofe_archivos', nid_carpeta );
    unotificar.esperando_inicio('Subiendo archivo empaquetado.');
    res:= upload_archi(dbcon, 'ofe_archivos', nid_carpeta, zipname);
    unotificar.esperando_fin;
    if res >= 0 then
      unotificar.notificar( 'El fue subido exitosamente. Nid asignado: '+IntToStr( res ) )
    else
      unotificar.notificar( 'Ojo, falló la subida del archivo. '+u_updownload.UltimoError, true)

  end;
end;

procedure TForm_EditorProblema.Button2Click(Sender: TObject);
begin
  ModalResult := -1;
end;

procedure TForm_EditorProblema.Button3Click(Sender: TObject);
var
  flt: TForm_PIG_ListadoTecnologias;
  flm: TForm_PAM_ListadoOrdenes;
  fmtexto: TForm_TextArea;
  fmOptimA: TForm_OptimA_info;
  rec: TDataRecord;
  res: integer;
  tipo: integer;
  nid_data: integer;
  str_data: string;
  regasificadora: string;
  largoagenda: integer;
begin

  tipo := nid_tipos[cbTipos.ItemIndex];
  case tipo of
    1:
    begin
      // PIG
      flt := TForm_PIG_ListadoTecnologias.Create(self, dbcon );
      flt.LoadRec(StrToInt(eNID_Problema.Text));
      res := flt.ShowModal;
      flt.Free;
    end;
    2:
    begin
      // PAM
      flm := TForm_PAM_ListadoOrdenes.Create(self, dbcon );
      flm.LoadRec(StrToInt(eNID_Problema.Text));
      res := flm.ShowModal;
      flm.Free;
    end;
    3:
    begin
      // OPTDET Optimización Deterministica
      // optdet ... sin terminar
    end;
    4:
    begin
      // RedCEGH Reductor de espacio de estado de procesos CEGH
      fmtexto:= TForm_TextArea.Create( self );
      rec:= dbcon.sql_ficha( 'SELECT nid, data FROM ofe_RedCEGH_data WHERE nid_problema  = ' + eNID_Problema.Text + ' LIMIT 1' );
      if rec <> nil then
      begin
        nid_data:= rec.GetByNameAsInt('nid');
        str_data:= rec.GetByNameAsString( 'data' );
        rec.free;
      end
      else
      begin
        nid_data:= dbcon.sql_nextnid( 'ofe_RedCEGH_data' );
        str_data:= '';
        dbcon.sql_exec( 'INSERT INTO ofe_RedCEGH_data (nid, nid_problema) VALUES ('+ IntToStr( nid_data ) +', '+ eNID_Problema.Text +' ) ' );
      end;
      fmtexto.mtexto.Text:= str_data;
      if fmtexto.ShowModal > 0 then
        dbcon.sql_exec( 'UPDATE ofe_RedCEGH_data SET data = "'+ fmtexto.mtexto.Text +'" WHERE nid = ' + IntToStr( nid_data ) );
      fmtexto.Free;
    end;
    5:
    begin
      fmOptimA:= TForm_OptimA_info.Create( self );
      rec:= dbcon.sql_ficha( 'SELECT nid, regasificadora, largo FROM ofe_OptimA WHERE nid_problema = '+eNID_Problema.Text );
      if rec <> nil then
      begin
        nid_data:= rec.GetByNameAsInt('nid');
        regasificadora:= rec.GetByNameAsString( 'regasificadora' );
        largoagenda:= rec.GetByNameAsInt( 'largo' );
        rec.free;
      end
      else
      begin
        nid_data:= dbcon.sql_nextnid( 'ofe_OptimA' );
        regasificadora:= '';
        largoagenda:= 0;
        dbcon.sql_exec( 'INSERT INTO ofe_OptimA (nid, nid_problema ) VALUES ('+ IntToStr( nid_data ) +', '+ eNID_Problema.Text +' ) ' );
      end;

      fmOptimA.eRegasificadora.Text:= regasificadora;
      fmOptimA.eLargo.Text:= IntToStr( largoagenda );
      if fmOptimA.ShowModal > 0 then
        dbcon.sql_exec( 'UPDATE ofe_OptimA SET regasificadora= "'+ fmOptimA.eRegasificadora.Text +'", largo='+fmOptimA.eLargo.Text+' WHERE nid = ' + IntToStr( nid_data ) );
      fmOptimA.Free;
    end;
    else
      ShowMessage('Problema tipo: base. No tiene información adicional a definir!');
  end;
end;

procedure TForm_EditorProblema.e_ro_binaryChange(Sender: TObject);
var
  resto: double;
begin
   try
     resto:= StrToFloat( e_ro_binary.text ) + StrToFloat( e_ro_gray.Text ) + StrToFloat( e_ro_unary.Text ) ;
     resto:= 1- resto;
     e_ro_fosil_agosto2011.text:= FloatToStr( resto );
   Except
     e_ro_fosil_agosto2011.text:= '?';
   end;
end;



constructor TForm_EditorProblema.Create( TheOwner: TComponent; dbconx: TDBrosxCon );
begin
  inherited Create( TheOwner );
  dbcon:= dbconx;
end;

procedure TForm_EditorProblema.LoadRec(nid: integer);
var
  ds: TResultadoQuery;
  r: TDataRecord;
  idTipo: string;
  cnt: integer;

begin
  eNID_Problema.Text := IntToStr(nid);
  ds := dbcon.sql_query('SELECT * FROM ofe_problemas WHERE nid= ' +
    eNID_Problema.Text );
  r := ds.First;
  if (r <> nil) then
  begin
    e_dtCreacion.Text := r.GetByNameAsString('dt_creacion');

    e_fecha_primer_etapa.Text:= r.GetByNameAsString( 'fecha_primer_etapa' );
    e_dias_por_etapa.Text:= r.GetByNameAsString( 'dias_por_etapa' );
    e_n_etapas.Text:= r.GetByNameAsString( 'n_etapas' );

    e_ro_VE.Text := r.GetByNameAsString('ro_VE');
    e_ro_VaR.Text := r.GetByNameAsString('ro_VaR');
    e_ro_CVaR.Text := r.GetByNameAsString('ro_CVaR');
    e_N_CronicasPorVez.Text := r.GetByNameAsString('N_CronicasPorVez');
    e_N_DiscretizacionHistograma.Text :=
      r.GetByNameAsString('N_DiscretizacionesHistograma');
    e_semilla_madre.Text := r.GetByNameAsString('semilla_madre');
    e_ro_GA.Text := r.GetByNameAsString('ro_GA');
    e_ro_EG.Text := r.GetByNameAsString('ro_EG');
    e_ro_MJ.Text := r.GetByNameAsString('ro_MJ');
    e_GA_prob_premio_exito.Text := r.GetByNameAsString('GA_prob_premio_exito');
    e_GA_prob_mutacion.Text := r.GetByNameAsString('GA_prob_mutacion');
    e_descripcion.Text := r.GetByNameAsString('descripcion');
    e_sala_simsee.Text := r.GetByNameAsString('sala_simsee');

    e_ro_binary.Text:= r.GetByNameAsString( 'ro_binary' );
    e_ro_gray.Text:= r.GetByNameAsString( 'ro_gray' );
    e_ro_unary.Text:= r.GetByNameAsString( 'ro_unary' );
    e_ro_fosil_agosto2011.Text:= r.GetByNameAsString( 'ro_fosil_agosto2011' );

    idTipo := r.GetByNameAsString('tipo');


    ds := dbcon.sql_query('SELECT * FROM ofe_tipos_problema LEFT JOIN ofe_tipo_problema_grupo ON ofe_tipo_problema_grupo.tipo= ofe_tipos_problema.nid WHERE ofe_tipo_problema_grupo.grupo = '+ IntToStr(dbcon.usuario_grupo)+' ORDER BY nid');
    r := ds.First;
    setlength(nid_tipos, ds.nrows);
    cbTipos.Items.Clear;
    cbTipos.ItemIndex := -1;
    cbTipos.Text := '--seleccione--';
    cnt := 0;
    while r <> nil do
    begin
      nid_tipos[cnt] := r.GetByNameAsInt('nid');
      cbTipos.Items.Add(r.GetByNameAsString('nombre'));
      if r.GetByNameAsString('nid') = idTipo then
      begin
        cbTipos.ItemIndex := cbTipos.Items.Count - 1;
        cbTipos.Text := r.GetByNameAsString('nombre');
      end;
      r := ds.Next;
      Inc(cnt);
    end;
  end;
end;

procedure TForm_EditorProblema.writeToRec;
var
  sql: string;
  tipo: integer;
  archi: string;
begin
  archi:= e_sala_simsee.Text;
  while pos( '\', archi ) > 0 do
   delete( archi, 1, pos( '\', archi ) );

  tipo := nid_tipos[cbTipos.ItemIndex];
  sql := 'UPDATE ofe_problemas SET '
  +  'fecha_primer_etapa = '''+if_vacio( e_fecha_primer_etapa.Text, '1900-01-01 00:00' )+ ''' '
  +  ', dias_por_etapa = '+ e_dias_por_etapa.Text
  +  ', n_etapas = '+ e_n_etapas.Text
    + ', ro_VE = ''' + e_ro_VE.Text +
    ''', ' + ' ro_VaR = ''' + e_ro_VaR.Text + ''', ' + ' ro_CVaR = ''' +
    e_ro_CVaR.Text + ''', ' + ' N_CronicasPorVez = ''' + e_N_CronicasPorVez.Text +
    ''', ' + ' N_DiscretizacionesHistograma = ''' + e_N_DiscretizacionHistograma.Text +
    ''', ' + ' semilla_madre = ''' + e_semilla_madre.Text + ''', ' + ' ro_GA = ''' +
    e_ro_GA.Text + ''', ' + ' ro_EG = ''' + e_ro_EG.Text + ''', ' + ' ro_MJ = ''' +
    e_ro_MJ.Text + ''', ' + ' GA_prob_premio_exito = ''' + e_GA_prob_premio_exito.Text +
    ''', ' + ' GA_prob_mutacion = ''' + e_GA_prob_mutacion.Text +

    ''', ' + ' ro_binary = ''' + e_ro_binary.Text +
    ''', ' + ' ro_gray = ''' + e_ro_gray.Text +
    ''', ' + ' ro_unary = ''' + e_ro_unary.Text +
    ''', ' + ' ro_fosil_agosto2011 = ''' + e_ro_fosil_agosto2011.Text +

    ''', ' + ' tipo = ' + IntToStr(tipo) + ', ' + ' descripcion = ''' +
    escapeChars(e_descripcion.Text) + ''', ' + ' sala_simsee = ''' +
    escapeChars(archi) + ''' '
    + ' WHERE nid = ' + eNID_Problema.Text;
  dbcon.sql_exec(sql);
end;

end.
