unit u_pam_editorordenes;

{$mode delphi}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  urosx, uDataSetGenerico, uvisordetabla,
  uconstantesSimSEE, unotificar, u_pam_editororden;


type

    { TPAM_ListadoOrdenes }

    TPAM_ListadoOrdenes = class ( TTabla )
      public
        flg_populate: boolean;
        nid_problema: integer;
        dbcon: TDBrosxCon;
        constructor Create(AOwner: TComponent; dbconx: TDBrosxCon; Name: string ); reintroduce;
        procedure Borrar_OnClick( nidRec: string; kFila: integer ); override;
        procedure Editar_onClick(nidRec: string; kFila: integer); override;
        procedure SemaforoRojo_OnClick(nidRec: string; kFila: integer); override;
        procedure SemaforoVerde_OnClick(nidRec: string; kFila: integer); override;
        procedure clonar_OnClick( nidRec: string; kFila: integer ); override;
        procedure Paint; override;
        procedure Populate;
    end;



  { TForm_PAM_ListadoOrdenes }

  TForm_PAM_ListadoOrdenes = class(TForm)
    Button2: TButton;
    ScrollBox1: TScrollBox;
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    lst: TPAM_ListadoOrdenes;
    dbcon: TDBrosxCon;

    constructor Create( TheOwner: TComponent; dbconx: TDBrosxCon );
    procedure LoadRec( nid_problema: integer );

  end;

implementation

{$R *.lfm}

{ TForm_PAM_ListadoOrdenes }

procedure TForm_PAM_ListadoOrdenes.FormCreate(Sender: TObject);
begin
    lst:= nil;
end;

procedure TForm_PAM_ListadoOrdenes.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
    if lst <> nil then
  begin
    lst.Free;
    lst:= nil;
  end;
end;

procedure TForm_PAM_ListadoOrdenes.Button2Click(Sender: TObject);
var
  fec: TForm_PAM_EditorOrden;
  sql: string;
  nid_Orden: integer;
  res: integer;

begin
  nid_Orden := dbcon.sql_nextnid( 'ofe_PAM_ordenes' );
  sql := 'INSERT INTO ofe_PAM_ordenes ( nid, nid_problema ) VALUES ( '+IntToSTr( nid_Orden )+', '+IntToStr( lst.nid_problema) +' )';
  dbcon.exec( sql );
  fec:= TForm_PAM_EditorOrden.Create( self, dbcon );
  fec.LoadRec( nid_Orden );
  res:= fec.ShowModal;
  fec.Free;
  lst.flg_populate:= true;
  lst.Invalidate;
end;


constructor TForm_PAM_ListadoOrdenes.Create( TheOwner: TComponent; dbconx: TDBrosxCon );
begin
  inherited Create( TheOwner );
  dbcon:= dbconx;
end;

procedure TForm_PAM_ListadoOrdenes.LoadRec( nid_problema: integer );
begin
  lst:= TPAM_ListadoOrdenes.Create( self.ScrollBox1, dbcon, 'lst_Ordenes' );
  lst.nid_problema:= nid_problema;
  lst.flg_populate:= true;
  lst.Invalidate;
end;


constructor TPAM_ListadoOrdenes.Create(AOwner: TComponent; dbconx: TDBrosxCon;
  Name: string);
begin
  inherited Create(AOwner, Name, 4, 1, 0 );
  dbcon:= dbconx;
  flg_populate:= true;
end;

procedure TPAM_ListadoOrdenes.Populate;
var
  k: Integer;
  r: TDataRecord;
  snid: string;
  ds: TResultadoQuery;
  estado: integer;
  jCol: integer;
begin


  flg_populate:= false;
  ds:= dbcon.Query(
    'SELECT * FROM ofe_PAM_ordenes WHERE nid_problema = '+ IntToStr( nid_problema ) +' ORDER BY nid DESC'
    );
  if ds = nil then
    raise Exception.Create( dbcon.ultimoError );

  ClearRedim( ds.nrows + 1, 8 );
  // fila encabezado
  wrTexto('', 0, 0, 'NID');
  wrTexto('', 0, 1, 'Nombre.');
  wrTexto('', 0, 2, 'Días de parada.');
  wrTexto('', 0, 3, 'Unidades.');
  wrTexto('', 0, 4, 'Primera fecha.');
  wrTexto('', 0, 5, 'Última fecha.');

  for jCol:= 0 to 5 do
    AlinearCelda(0, jCol, CAH_Izquierda, CAV_Centro );


  Self.SetBgColorFila(0, clNavy );
  Self.SetFontColorFila( 0, clYellow );

  Self.SetBgColorCelda(0, 0, clNavy );
  Self.SetBgColorCelda(0, 1, clNavy );

  k:= 1;
  r:= ds.first;
  while not ds.eof do
  begin
    snid:= r.GetByIdAsString(0);
    estado:= r.GetByNameAsInt( 'activa' );
    wrTexto('', k, 0, r.GetByNameAsString('nid'));
    wrTexto('', k, 1, r.GetByNameAsString('nombre'));
    wrTexto('', k, 2, r.GetByNameAsString('dias_parada'));
    wrTexto('', k, 3, r.GetByNameAsString('unidades_a_mantener'));
    wrTexto('', k, 4, r.GetByNameAsString('fecha_inicio'));
    wrTexto('', k, 5, r.GetByNameAsString('fecha_fin'));

    for jCol:= 0 to 7 do
      AlinearCelda(0, jCol, CAH_Izquierda, CAV_Centro );

    // ahora la botonera en la última columna

    wrBotonera( snid, k, 6,
                [ iid_Editar,
                iid_clonar,
                iid_borrar],
                [ hintPorDefecto(iid_Editar),
                hintPorDefecto(iid_Clonar),
                hintPorDefecto(iid_Borrar)]);


    if ( estado = 0 ) then
      wrBotonera( snid, k, 7,[ iid_SemaforoRojo ],['Activar'])
    else
      wrBotonera( snid, k, 7,[ iid_SemaforoVerde ],['Desactivar']);


    if (k mod 2) = 0 then
      if estado = 0 then
       SetBgColorFila(k, clFondoFilaPar_Inactiva )
      else
       SetBgColorFila(k, clFondoFilaPar_Activa )
    else
      if estado = 0 then
        SetBgColorFila(k, clFondoFilaImpar_Inactiva )
      else
        SetBgColorFila(k, clFondoFilaImpar_Activa );

    inc( k );
    r:= ds.next;
  end;
  reposicionar;
end;

procedure TPAM_ListadoOrdenes.Paint;
begin
  if flg_populate then Populate;
  inherited Paint;
end;

procedure TPAM_ListadoOrdenes.Borrar_OnClick( nidRec: string; kFila: integer );
var
  sql: string;
begin
  sql:= 'DELETE FROM ofe_PAM_ordenes WHERE nid = '+nidRec;
  dbcon.exec( sql );
  flg_populate:= true;
  Invalidate;
end;

procedure TPAM_ListadoOrdenes.Editar_onClick(nidRec: string; kFila: integer);
var
  ufc: TForm_PAM_EditorOrden;
  res: integer;

begin
  ufc:= TForm_PAM_EditorOrden.Create( self, dbcon );
  ufc.LoadRec( StrToInt( nidRec ) );
  res:=  ufc.ShowModal;
  if res > 0 then
  begin
    flg_populate:= true;
    invalidate;
  end;
  ufc.Free;
end;


procedure TPAM_ListadoOrdenes.SemaforoRojo_OnClick(nidRec: string; kFila: integer);
var
  sql: string;
begin
  sql:= 'UPDATE ofe_PAM_ordenes SET activa=1 WHERE nid = '+nidRec;
  dbcon.exec( sql );
  flg_populate:= true;
  invalidate;
end;

procedure TPAM_ListadoOrdenes.SemaforoVerde_OnClick(nidRec: string; kFila: integer);
var
  sql: string;
begin
  sql:= 'UPDATE ofe_PAM_ordenes SET activa=0 WHERE nid = '+nidRec;
  dbcon.exec( sql );
  flg_populate:= true;
  invalidate;
end;

procedure TPAM_ListadoOrdenes.clonar_OnClick( nidRec: string; kFila: integer );
var
  nid_destino, nid_origen: integer;
begin
  nid_origen:= StrToInt( nidRec );
  nid_destino := dbcon.clonar_rec( 'ofe_PAM_ordenes', nid_origen, -1, '' );
  Editar_onClick( IntToStr(nid_destino), 0 );
end;

end.

