unit u_PIG_editorTecnologia;

{$mode delphi}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, urosx, uDataSetGenerico, uvisordetabla, uconstantesSimSEE,
  unotificar;

type

  { TForm_PIG_Tecnologia }

  TForm_PIG_Tecnologia = class(TForm)
    btGuardar: TButton;
    btCancelar: TButton;
    e_indx_tasa: TEdit;
    e_indx_FV: TEdit;
    e_factor_unidades: TEdit;
    e_musd_por_unidad: TEdit;
    e_nombre: TEdit;
    e_max_unid_activas: TEdit;
    e_max_unid_por_vez: TEdit;
    e_fecha_fin: TEdit;
    e_fecha_inicio: TEdit;
    e_anios_vida_util: TEdit;
    e_meses_construccion: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    lbl_indx_tasa: TLabel;
    lbl_indx_FV: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure btCancelarClick(Sender: TObject);
    procedure btGuardarClick(Sender: TObject);
  private
    { private declarations }
  public
    dbcon: TDBrosxCon;
    nid_tecno: integer;

    constructor Create( TheOwner: TComponent; xdbcon: TDBrosxCon );
    { public declarations }
    procedure LoadRec(nid_tecno_: integer);
  end;


implementation

{$R *.lfm}

{ TForm_PIG_Tecnologia }

procedure TForm_PIG_Tecnologia.btCancelarClick(Sender: TObject);
begin
  ModalResult := -1;
end;

procedure TForm_PIG_Tecnologia.btGuardarClick(Sender: TObject);
var
  sql: string;


  procedure rwcp(e: TEdit; nombre: string);
  begin
    if sql <> '' then
      sql := sql + ', ';
    sql := sql + nombre + ' = ''' + trim(e.Text) + '''';
  end;

begin

  rwcp(e_nombre, 'nombre');
  rwcp(e_max_unid_activas, 'max_unid_activas');
  rwcp(e_max_unid_por_vez, 'max_unid_por_vez');
  rwcp(e_fecha_fin, 'fecha_fin');
  rwcp(e_fecha_inicio, 'fecha_inicio');
  rwcp(e_musd_por_unidad, 'musd_por_unidad');

  rwcp(e_indx_FV as TEdit, 'indx_fv');
  rwcp(e_indx_tasa, 'indx_tasa');

  rwcp(e_anios_vida_util, 'anios_vida_util');
  rwcp(e_meses_construccion, 'meses_construccion');
  rwcp(e_factor_unidades, 'factor_unidades');


  sql := 'UPDATE ofe_PIG_tecnologias SET ' + sql + ' WHERE nid = ' + IntToStr(
    nid_tecno);
  dbcon.sql_exec(sql);
  ModalResult := 1;
end;

constructor TForm_PIG_Tecnologia.Create( TheOwner: TComponent; xdbcon: TDBrosxCon );
begin
  inherited Create( TheOwner );
  dbcon:= xdbcon;
end;

procedure TForm_PIG_Tecnologia.LoadRec(nid_tecno_: integer);
var
  r: TDataRecord;
  snid: string;
  ds: TResultadoQuery;
  estado: integer;

  procedure rwcp(e: TEdit; nombre: string);
  begin
    e.Text := r.GetByNameAsString(nombre);
  end;

begin
  nid_tecno := nid_tecno_;
  ds := dbcon.sql_query('SELECT * FROM ofe_PIG_tecnologias WHERE nid = ' + IntToStr(
    nid_tecno) );
  if ds = nil then
    raise Exception.Create('Imposible encontrar el registro!');
  r := ds.First;

  rwcp(e_nombre, 'nombre');
  rwcp(e_max_unid_activas, 'max_unid_activas');
  rwcp(e_max_unid_por_vez, 'max_unid_por_vez');
  rwcp(e_fecha_fin, 'fecha_fin');
  rwcp(e_fecha_inicio, 'fecha_inicio');
  rwcp(e_musd_por_unidad, 'musd_por_unidad');

  rwcp(e_indx_FV, 'indx_fv');
  rwcp(e_indx_tasa, 'indx_tasa');

  rwcp(e_anios_vida_util, 'anios_vida_util');
  rwcp(e_meses_construccion, 'meses_construccion');
  rwcp(e_factor_unidades, 'factor_unidades');
end;


end.
