unit u_pig_editortecnologias;

{$mode delphi}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  urosx, uDataSetGenerico, uvisordetabla,
  uconstantesSimSEE, unotificar, u_PIG_editorTecnologia;


type
  TPIG_ListadoTecnologias = class ( TTabla )
    public
      dbcon: TDBrosxCon;
      flg_populate: boolean;
      nid_problema: integer;
      constructor Create(AOwner: TComponent; dbconx: TDBrosxCon;  Name: string ); reintroduce;
      procedure Borrar_OnClick( nidRec: string; kFila: integer ); override;
      procedure Editar_onClick(nidRec: string; kFila: integer); override;
      procedure SemaforoRojo_OnClick(nidRec: string; kFila: integer); override;
      procedure SemaforoVerde_OnClick(nidRec: string; kFila: integer); override;
      procedure clonar_OnClick( nidRec: string; kFila: integer ); override;
      procedure Paint; override;
      procedure Populate;
  end;

type

  { TForm_PIG_ListadoTecnologias }

  TForm_PIG_ListadoTecnologias = class(TForm)
    btAgregarNueva: TButton;
    ScrollBox1: TScrollBox;
    dbcon: TDBrosxCon;
    procedure btAgregarNuevaClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    constructor Create( TheOwner: TComponent; dbconx: TDBrosxCon );
  private
    { private declarations }
  public
    { public declarations }
    lst: TPIG_ListadoTecnologias;
    procedure LoadRec( nid_problema: integer );
  end;


implementation

{$R *.lfm}

constructor TForm_PIG_ListadoTecnologias.Create( TheOwner: TComponent; dbconx: TDBrosxCon );
begin
  inherited Create( TheOwner );
  dbcon:= dbconx;
end;

procedure TForm_PIG_ListadoTecnologias.FormCreate(Sender: TObject);
begin
  lst:= nil;
end;

procedure TForm_PIG_ListadoTecnologias.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  if lst <> nil then
  begin
    lst.Free;
    lst:= nil;
  end;
end;

procedure TForm_PIG_ListadoTecnologias.btAgregarNuevaClick(Sender: TObject);
var
  fet: TForm_PIG_Tecnologia;
  sql: string;
  nid_tecno: integer;
  res: integer;

begin
  nid_tecno := dbcon.sql_nextnid( 'ofe_PIG_tecnologias' );
  sql := 'INSERT INTO ofe_PIG_tecnologias ( nid, nid_problema ) VALUES ( '+IntToSTr( nid_tecno )+', '+IntToStr( lst.nid_problema) +' )';
  dbcon.sql_exec( sql );
  fet:= TForm_PIG_Tecnologia.Create( self, dbcon );
  fet.LoadRec( nid_tecno );
  res:= fet.ShowModal;
  fet.Free;
  lst.flg_populate:= true;
  lst.Invalidate;


end;

procedure TForm_PIG_ListadoTecnologias.LoadRec( nid_problema: integer );
begin
  lst:= TPIG_ListadoTecnologias.Create( self.ScrollBox1, dbcon, 'lst_tecnologias' );
  lst.nid_problema:= nid_problema;
  lst.flg_populate:= true;
  lst.Invalidate;
end;

constructor TPIG_ListadoTecnologias.Create(
  AOwner: TComponent; dbconx: TDBrosxCon; Name: string );
begin
  inherited Create(AOwner, Name, 4, 1, 0 );
  dbcon:= dbconx;
  flg_populate:= true;
end;

procedure TPIG_ListadoTecnologias.Populate;
var
  k: Integer;
  r: TDataRecord;
  snid: string;
  ds: TResultadoQuery;
  estado: integer;
  jCol: integer;
begin


  flg_populate:= false;
  ds:= dbcon.Query(
    'SELECT * FROM ofe_PIG_tecnologias WHERE nid_problema = '+ IntToStr( nid_problema ) +' ORDER BY nid DESC'
    );
  if ds = nil then
    raise Exception.Create( dbcon.ultimoError );

  ClearRedim( ds.nrows + 1, 12 );
  // fila encabezado
  wrTexto('', 0, 0, 'NID');
  wrTexto('', 0, 1, 'Nombre.');
  wrTexto('', 0, 2, 'Meses constr.');
  wrTexto('', 0, 3, 'Años vida.');
  wrTexto('', 0, 4, 'MUSD/UI.');
  wrTexto('', 0, 5, 'Fecha ini.');
  wrTexto('', 0, 6, 'Fecha fin.');
  wrTexto('', 0, 7, 'Máx. UI/vez.');
  wrTexto('', 0, 8, 'Máx. UIs.');
  wrTexto('', 0, 9, 'Factor UG/UI');

  for jCol:= 0 to 9 do
    AlinearCelda(0, jCol, CAH_Izquierda, CAV_Centro );


  Self.SetBgColorFila(0, clNavy );
  Self.SetFontColorFila( 0, clYellow );

  Self.SetBgColorCelda(0, 0, clNavy );
  Self.SetBgColorCelda(0, 1, clNavy );

  k:= 1;
  r:= ds.first;
  while not ds.eof do
  begin
    snid:= r.GetByIdAsString(0);
    estado:= r.GetByNameAsInt( 'activa' );
    wrTexto('', k, 0, r.GetByNameAsString('nid'));
    wrTexto('', k, 1, r.GetByNameAsString('nombre'));
    wrTexto('', k, 2, r.GetByNameAsString('meses_construccion'));
    wrTexto('', k, 3, r.GetByNameAsString('anios_vida_util'));

    wrTexto('', k, 4, r.GetByNameAsString('musd_por_unidad'));
    wrTexto('', k, 5, r.GetByNameAsString('fecha_inicio'));
    wrTexto('', k, 6, r.GetByNameAsString('fecha_fin'));

    wrTexto('', k, 7, r.GetByNameAsString('max_unid_por_vez'));
    wrTexto('', k, 8, r.GetByNameAsString('max_unid_activas'));
    wrTexto('', k, 9, r.GetByNameAsString('factor_unidades'));

    for jCol:= 0 to 9 do
      AlinearCelda(0, jCol, CAH_Izquierda, CAV_Centro );

    // ahora la botonera en la última columna

    wrBotonera( snid, k, 10,
                [ iid_Editar,
                iid_clonar,
                iid_borrar],
                [ hintPorDefecto(iid_Editar),
                hintPorDefecto(iid_Clonar),
                hintPorDefecto(iid_Borrar)]);


    if ( estado = 0 ) then
      wrBotonera( snid, k, 11,[ iid_SemaforoRojo ],['Activar'])
    else
      wrBotonera( snid, k, 11,[ iid_SemaforoVerde ],['Desactivar']);


    if (k mod 2) = 0 then
      if estado = 0 then
       SetBgColorFila(k, clFondoFilaPar_Inactiva )
      else
       SetBgColorFila(k, clFondoFilaPar_Activa )
    else
      if estado = 0 then
        SetBgColorFila(k, clFondoFilaImpar_Inactiva )
      else
        SetBgColorFila(k, clFondoFilaImpar_Activa );

    inc( k );
    r:= ds.next;
  end;
  reposicionar;
end;

procedure TPIG_ListadoTecnologias.Paint;
begin
  if flg_populate then Populate;
  inherited Paint;
end;

procedure TPIG_ListadoTecnologias.Borrar_OnClick( nidRec: string; kFila: integer );
var
  sql: string;
begin
  sql:= 'DELETE FROM ofe_PIG_tecnologias WHERE nid = '+nidRec;
  dbcon.exec( sql );
  flg_populate:= true;
  Invalidate;
end;

procedure TPIG_ListadoTecnologias.Editar_onClick(nidRec: string; kFila: integer);
var
  uft: TForm_PIG_Tecnologia;
  res: integer;

begin
  uft:= TForm_PIG_Tecnologia.Create( self, dbcon );
  uft.LoadRec( StrToInt( nidRec ) );
  res:=  uft.ShowModal;
  if res > 0 then
  begin
    flg_populate:= true;
    invalidate;
  end;
  uft.Free;
end;


procedure TPIG_ListadoTecnologias.SemaforoRojo_OnClick(nidRec: string; kFila: integer);
var
  sql: string;
begin
  sql:= 'UPDATE ofe_PIG_tecnologias SET activa=1 WHERE nid = '+nidRec;
  dbcon.exec( sql );
  flg_populate:= true;
  invalidate;
end;

procedure TPIG_ListadoTecnologias.SemaforoVerde_OnClick(nidRec: string; kFila: integer);
var
  sql: string;
begin
  sql:= 'UPDATE ofe_PIG_tecnologias SET activa=0 WHERE nid = '+nidRec;
  dbcon.exec( sql );
  flg_populate:= true;
  invalidate;
end;



procedure TPIG_ListadoTecnologias.clonar_OnClick( nidRec: string; kFila: integer );
var
  nid_destino, nid_origen: integer;
begin
  nid_origen:= StrToInt( nidRec );
  nid_destino := dbcon.clonar_rec( 'ofe_PIG_tecnologias', nid_origen, -1, '' );
  Editar_onClick( IntToStr(nid_destino), 0 );
end;


end.

