unit ulistadocarpetas;

{$mode delphi}

interface

uses
  SysUtils, Classes, Controls,
  Forms,
  urosx, uDataSetGenerico, StdCtrls, uvisordetabla,
  uconstantesSimSEE, unotificar;

type

  { TListadoCarpetas }

  TListadoCarpetas = class ( TTabla )
    public
      dbcon: TDBrosxCon;
      constructor Create( dbconx: TDBrosxCon; AOwner: TComponent; Name: string ); reintroduce;
      procedure Borrar_OnClick( nidRec: string; kFila: integer ); override;
      procedure fdownload_OnClick( nidRec: string; kFila: integer ); override;
      procedure Populate;
  end;

implementation

function eliminarCarpeta(dbcon: TDBrosxCon; nidCarpeta: string ): boolean;
var
  pathCarpeta: String;
  texto: String;
  sql: string;
begin
  result:= false;
  pathCarpeta:= dbcon.sql_func('SELECT path FROM ofe_carpetas WHERE nid = ' + nidCarpeta + ' LIMIT 1');

  texto:= '¿Confirma que desea eliminar la carpeta ' + pathCarpeta + ' con todos sus archivos?';

  if confirmar( texto, ['Si', 'No' ] ) = 'Si' then
  begin
    sql:= 'DELETE FROM ofe_archivos WHERE nid_carpeta = ' + nidCarpeta;
    if not dbcon.sql_exec( sql ) then
      raise Exception.Create( dbcon.UltimoError );

    sql:= 'DELETE FROM ofe_carpetas WHERE nid = ' + nidCarpeta;

  if not dbcon.sql_exec( sql ) then
      raise Exception.Create( dbcon.UltimoError );
    result:= true;
  end
end;

procedure bajarCarpeta(dbcon: TDBrosxCon; nidCarpeta: string );
var
  pathCarpeta, nomArch, error: String;
  chkSumRemoto, chkSumLocal: ShortString;
  orden: String;
  cursorAnterior: TCursor;
  f: TextFile;
  ds: TResultadoQuery;
  rCarpeta, rArchi: TDataRecord;
  datos: String;
begin
  rCarpeta:= dbcon.sql_ficha( 'SELECT fecha, path, descripcion FROM ofe_carpetas WHERE nid='+nidCarpeta+' LIMIT 1');
  pathCarpeta:= getDir_SimSEE + rCarpeta.GetByNameAsString('path');
  cursorAnterior:= Screen.Cursor;
  Screen.Cursor:= crHourGlass;

  try
    orden:= 'SELECT nombre, checksum, datos FROM ofe_archivos WHERE nid_carpeta = ' + nidCarpeta;
    ds:= dbcon.sql_query( orden );

    if ds = nil then
      raise Exception.Create( dbcon.UltimoError );

    ForceDirectories(pathCarpeta);

    error:= '';

    rArchi:= ds.first;
    while not ds.eof do
    begin
      nomArch:= rArchi.GetByNameAsString( 'nombre' );
      chkSumRemoto:= rArchi.GetByNameAsString('checksum');
      datos:= rArchi.GetByNameAsString( 'datos' );
      chkSumLocal:= checksum(@datos[1], length(datos));
      if chkSumLocal = chkSumRemoto then
      begin
        AssignFile(f, pathCarpeta + nomArch);
        Rewrite(f);
        Write(f, datos);
        CloseFile(f);
      end
      else
      begin
        error:= error + nomArch + #13#10;
      end;
      rArchi:= ds.next;
    end;
    ds.Free;

    if error = '' then
      notificar('Los archivos se descargaron correctamente en ' + pathCarpeta)
    else
      notificar('Se encontraron errores al descargar los siguientes archivos:'#13#10 +
                  error +
                  'Intente descargarlos nuevamente, si el error persiste contáctese con ADME.', true);
  finally
    Screen.Cursor:= cursorAnterior;
  end;
end;

constructor TListadoCarpetas.Create(dbconx: TDBrosxCon; AOwner: TComponent;
  Name: string);
begin
  inherited Create(AOwner, Name, 4, 1, 0 );
  dbcon:= dbconx;
end;

procedure TListadoCarpetas.Populate;
var
  k: Integer;
  r: TDataRecord;
  snid: string;
  ds: TResultadoQuery;
begin
  ds:= dbcon.Query('SELECT nid, fecha, path, descripcion FROM ofe_carpetas ORDER BY nid DESC');
  if ds = nil then
    raise Exception.Create( dbcon.ultimoError );

  ClearRedim( ds.nrows + 1, ds.nfields );
  // fila encabezado
  wrTexto('', 0, 0, 'Fecha');
  wrTexto('', 0, 1, 'Carpeta');
  wrTexto('', 0, 2, 'Descripcion');

  AlinearCelda(0, 0, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 1, CAH_Izquierda, CAV_Centro );
  AlinearCelda(0, 2, CAH_Izquierda, CAV_Centro );

  Self.SetBgColorFila(0, clFondoFixedCells );
  Self.SetFontColorFila( 0, clFontFixedCells );

  k:= 1;
  r:= ds.first;
  while not ds.eof do
  begin
    snid:= r.GetByIdAsString(0);
    wrTexto('', k, 0, r.GetByNameAsString('fecha'));
    wrTexto('', k, 1, r.GetByNameAsString('path'));
    wrTexto('', k, 2, r.GetByNameAsString('descripcion'));
    AlinearCelda(k, 0, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 1, CAH_Izquierda, CAV_Centro );
    AlinearCelda(k, 2, CAH_Izquierda, CAV_Centro );

    // ahora la botonera en la última columna
    if dbcon.usuario_EsAdmin then
      wrBotonera( snid, k, 3,
                [ iid_fdownload, iid_Editar, iid_borrar],
                [hintPorDefecto(iid_fdownload), hintPorDefecto(iid_Editar), hintPorDefecto(iid_Borrar)])
    else
      wrBotonera( snid, k, 3,
                [ iid_fdownload],
                [hintPorDefecto(iid_fdownload)]);

    if (k mod 2) = 0 then
      SetBgColorFila(k, clFondoFilaPar )
    else
      SetBgColorFila(k, clFondoFilaImpar );

    inc( k );
    r:= ds.next;
  end;
  reposicionar;
end;

procedure TListadoCarpetas.Borrar_OnClick( nidRec: string; kFila: integer );
begin
  if eliminarCarpeta(dbcon, nidRec ) then
    Populate; // prefiero polular
end;

procedure TListadoCarpetas.fdownload_OnClick( nidRec: string; kFila: integer );
begin
  bajarCarpeta(dbcon, nidRec );
end;



end.

