unit uListadoProblemas;

{$mode delphi}

interface

uses
  SysUtils, Classes, Controls,
  Forms,
  Graphics,
  urosx,
  StdCtrls, uvisordetabla,
  uconstantesSimSEE,
  unotificar,
  u_updownload;

type
  { TListadoProblemas }
  TListadoProblemas = class ( TTabla )
    public
      flg_populate: boolean;
      dbcon: TDBrosxCon;
      constructor Create(dbconx: TDBrosxCon; AOwner: TComponent; Name: string ); reintroduce;
      procedure Borrar_OnClick( nidRec: string; kFila: integer ); override;
      procedure fdownload_OnClick(tbl_carpetas, tbl_archivos:string; nidRec: string; kFila: integer );
      procedure Paint; override;
      procedure Populate; virtual; abstract;
      class function CrearNuevoProblema: integer;virtual;abstract;
      procedure eliminarProblema( nidCarpeta: string ); virtual; abstract;
  end;



implementation
uses
  uoddface_prepare;

constructor TListadoProblemas.Create(dbconx: TDBrosxCon; AOwner: TComponent;
  Name: string);
begin
  inherited Create(AOwner, Name, 4, 1, 0 );
  dbcon:= dbconx;
  flg_populate:= true;
end;

procedure TListadoProblemas.Paint;
begin
  if flg_populate then Populate;
  inherited Paint;
end;

procedure TListadoProblemas.Borrar_OnClick( nidRec: string; kFila: integer );
var
  texto: String;
begin
  texto:= '¿Confirma que desea eliminar el Problema: ' + nidRec + ' con todos sus archivos?';
  if confirmar( texto, ['Si', 'No' ] ) = 'Si' then
  begin
    eliminarProblema( nidRec );
    flg_populate:= true;
    Invalidate;
    //  Populate; // prefiero polular
  end;
end;

procedure TListadoProblemas.fdownload_OnClick(tbl_carpetas,
  tbl_archivos: string; nidRec: string; kFila: integer);
var
  res_ok: boolean;
begin
  unotificar.esperando_inicio( 'bajando carpeta' );
  res_ok:= bajarCarpeta( dbcon, tbl_carpetas, tbl_archivos, StrToInt( nidRec ) );
  unotificar.esperando_fin;
  if res_ok then
   unotificar.notificar( 'La carpeta fue bajada exitosamente.')
  else
   unotificar.notificar( u_updownload.UltimoError, true);
end;

end.

