unit uoddface_prepare;
interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ExtCtrls,
  ssl_openssl,
  urosx,
  xmatdefs,
  uListadoProblemasODDFACE,
  uDataSetGenerico,
  uconstantessimsee,
  unotificar,
  uversiones_oddface,
  uvisordetabla,
  uoddfaceconfig;


type

  { TFormPrincipal }

  TFormPrincipal = class(TForm)
    btNuevo: TButton;
    btRefrescar: TButton;
    Button1: TButton;
    Button2: TButton;
    cb_recordar_clave_proxy: TCheckBox;
    cb_recordar_clave_simsee: TCheckBox;
    eUsuarioSimSEE: TEdit;
    eClaveSimSEE: TEdit;
    eproxy_host: TEdit;
    eproxy_pass: TEdit;
    eproxy_puerto: TEdit;
    eproxy_user: TEdit;
    e_ros_host: TLabeledEdit;
    e_ros_uri: TLabeledEdit;
    e_ros_port: TLabeledEdit;
    gb_ProxyParams: TGroupBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label15: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    e_ros_ip: TLabeledEdit;
    memo_login: TMemo;
    PageControl1: TPageControl;
    Panel1: TPanel;
    Panel2: TPanel;
    ScrollBox1: TScrollBox;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    procedure btCrearTablasDBClick(Sender: TObject);
    procedure btNuevoClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure btRefrescarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { private declarations }

  public
    { public declarations }
    lst_problemas: TListadoProblemasODDFACE;
    dbcon: TDBrosxCon;
    oddface_cfg: TOddFaceConfigRec;

    procedure LoadConfig;
    procedure SaveConfig;

  end;

var
  FormPrincipal: TFormPrincipal;

implementation

{$R *.lfm}

{ TFormPrincipal }



procedure TFormPrincipal.btNuevoClick(Sender: TObject);
var
  nid_problema: integer;
  sql: string;
  str_nombres, str_valores: string;
begin

 nid_problema := TListadoProblemasODDFACE.CrearNuevoProblema( dbcon );

 if lst_problemas <> nil then
 begin
   lst_problemas.flg_populate:= true;
   lst_problemas.Editar_onClick( intToStr( nid_problema ), 0 );
 end;

end;

procedure TFormPrincipal.btCrearTablasDBClick(Sender: TObject);
begin

end;


procedure TFormPrincipal.loadconfig;
begin
  oddface_cfg:= get_OddFace_cfg;
  eUsuarioSimSEE.text:= oddface_cfg.UsuarioSimSEE;
  eClaveSimSEE.text:= oddface_cfg.ClaveSimSEE;
  e_ros_ip.text:= oddface_cfg.ros_ip;
  e_ros_host.text:= oddface_cfg.ros_host;
  e_ros_port.text:= oddface_cfg.ros_port;
  e_ros_uri.text:= oddface_cfg.ros_uri;
  eproxy_host.text:= oddface_cfg.proxy_host;
  eproxy_puerto.text:= oddface_cfg.proxy_port;
  eproxy_user.text:= oddface_cfg.proxy_user;
  eproxy_pass.text:= oddface_cfg.proxy_pass;
  cb_recordar_clave_proxy.checked := oddface_cfg.flg_recordar_clave_proxy;
  cb_recordar_clave_simsee.checked := oddface_cfg.flg_recordar_clave_simsee;
end;


procedure TFormPrincipal.saveconfig;
begin
  oddface_cfg:= get_OddFace_cfg;

  oddface_cfg.UsuarioSimSEE:= eUsuarioSimSEE.text;

  oddface_cfg.flg_recordar_clave_simsee:= cb_recordar_clave_simsee.checked;

 if oddface_cfg.flg_recordar_clave_simsee then
     oddface_cfg.ClaveSimSEE:= eClaveSimSEE.text
  else
     oddface_cfg.ClaveSimSEE:= '';

  oddface_cfg.ros_ip:= e_ros_ip.text;
  oddface_cfg.ros_host:= e_ros_host.text;
  oddface_cfg.ros_port:= e_ros_port.text;
  oddface_cfg.ros_uri:= e_ros_uri.text;

  oddface_cfg.proxy_host:= eproxy_host.text;
  oddface_cfg.proxy_port:= eproxy_puerto.text;
  oddface_cfg.proxy_user:= eproxy_user.text;
  oddface_cfg.flg_recordar_clave_proxy:= cb_recordar_clave_proxy.checked;
  if oddface_cfg.flg_recordar_clave_proxy then
    oddface_cfg.proxy_pass:= eproxy_pass.text
  else
   oddface_cfg.proxy_pass:= '';

  oddface_cfg.Save;
end;


procedure TFormPrincipal.Button1Click(Sender: TObject);
var
  hora: string;
begin
  {$IFDEF PROXY_ENABLED_ROS}
  dbcon.proxy_host:= trim( eproxy_host.text );
  dbcon.proxy_port:= trim( eproxy_puerto.text );
  dbcon.proxy_user:= trim( eproxy_user.text );
  dbcon.proxy_pass:= trim( eproxy_pass.text );
  {$ENDIF}
  unotificar.esperando_inicio('... intentando conexión con servidor de IIE-FING...');
  hora:= dbcon.sql_func( 'SELECT now() FROM ofe_problemas LIMIT 1 ' );
  if hora <> '' then
  begin
    memo_login.Lines.add('Se ha conectado correctamente al servidor del IIE-FING');
    memo_login.lines.add(' .. la hora del servidor es: '+hora );
    saveconfig;
  end
  else
  begin
    memo_login.Lines.add('FALLO INTENTO DE CONEXIÓN' );
  end;
  unotificar.esperando_fin;
end;

procedure TFormPrincipal.Button2Click(Sender: TObject);
var
  hora: string;
  clave: string;
  ficha: TDataRecord;
begin
  {$IFDEF PROXY_ENABLED_ROS}
  dbcon.proxy_host:= trim( eproxy_host.text );
  dbcon.proxy_port:= trim( eproxy_puerto.text );
  dbcon.proxy_user:= trim( eproxy_user.text );
  dbcon.proxy_pass:= trim( eproxy_pass.text );
  {$ENDIF}
  dbcon.usuario_email:= trim( eUsuarioSimSEE.text );
  dbcon.ipfija:= trim(e_ros_ip.text);
  dbcon.host:= trim( e_ros_host.text );
  dbcon.uri_rosx:= trim( e_ros_uri.Text );
  dbcon.puerto:= trim( e_ros_port.text ) ;
  clave:= trim( eClaveSimSEE.text );
  try
    unotificar.esperando_inicio('... Intentando conexión con servidor '+ dbcon.host +' ....');
    dbcon.usuario_loginok:= true;
    ficha:= dbcon.sql_ficha( 'SELECT now() as hora, nid, grupo, tipo FROM ofe_usuarios WHERE email ='''+dbcon.usuario_email+''' AND clave='''+clave+'''; ' );
    dbcon.usuario_loginok:= false;
    if ficha <> nil then
    begin
      hora:= ficha.GetByNameAsString('hora');
      dbcon.usuario_nid:= ficha.GetByNameAsInt( 'nid' );
      dbcon.usuario_grupo:= ficha.GetByNameAsInt( 'grupo' );
      dbcon.usuario_tipo:= ficha.GetByNameAsInt( 'tipo' );
      dbcon.usuario_loginok:= dbcon.usuario_nid > 0;
      ficha.Free;
    end;

    if not dbcon.usuario_loginok then
    begin
      unotificar.esperando_fin;
      unotificar.notificar( 'Falló verificación de ingreso.', true );
      exit;
    end;


    dbcon.determinar_tipo_servidor;

    unotificar.esperando_fin;
    if hora <> '' then
    begin
      saveconfig;
      PageControl1.TabIndex:= 0;
      TabSheet1.Enabled:= true;
      TabSheet1.Visible:= true;
      TabSheet2.Enabled:= false;
      TabSheet2.Visible:= false;
      lst_problemas.flg_populate:= true;
    end
    else
      unotificar.notificar( 'No fue posible conectarse al servidor. Si usted está detrás de un PROXY debe configurarlo.', true );
  finally
  end;
end;

procedure TFormPrincipal.btRefrescarClick(Sender: TObject);
begin
  if lst_problemas = nil then
  begin
    lst_problemas:= TListadoProblemasODDFACE.Create( dbcon, scrollbox1, 'lst_problemas' );
    lst_problemas.Parent:= scrollbox1;
  end;
  lst_problemas.flg_populate:= true;
  lst_problemas.Invalidate;
  ScrollBox1.AutoScroll:=false;

end;


procedure TFormPrincipal.FormCreate(Sender: TObject);
begin

  loadconfig;

  PageControl1.TabIndex:= 1;
  TabSheet1.Enabled:= false;
  TabSheet1.Visible:= false;
  TabSheet2.Enabled:= true;
  tabsheet2.visible:= true;

 //  dbcon:= TDBrosxCon.Create('', 'iie.fing.edu.uy', '80', '/simsee/ros/rosx.php' );
 //  dbcon:= TDBrosxCon.Create('', 'iie.fing.edu.uy', '80', '/simsee/ros/rosx.php' );
  dbcon:= TDBrosxCon.Create('', 'latorre.adme.com.uy', '80', '/zeros/x/rosx.php' );

  lst_problemas:= TListadoProblemasODDFACE.Create(dbcon, scrollbox1, 'lst_problemas' );
  lst_problemas.Parent:= scrollbox1;
  lst_problemas.flg_populate:= false;

  Caption:= 'OddFace - '+uversiones_oddface.vOddFace+' (c) IIE-FING';

  {$IFDEF PROXY_ENABLED_ROS}
  gb_ProxyParams.visible:= true;
  {$ENDIF}
end;


procedure TFormPrincipal.Timer1Timer(Sender: TObject);
begin
  lst_problemas.populate;
end;

(**
procedure TFormPrincipal.Button3Click(Sender: TObject);
var
  ds: TResultadoQuery;
  r: TDataRecord;
begin
  ds:= sql_query( 'SELECT nid FROM ofe_problemas WHERE tipo = 2' );
  r:= ds.first;
  while r<> nil do
  begin
    sql_exec( 'DELETE FROM ofe_individuos_'+ r.GetByNameAsString('nid')+' WHERE dtu > ''2012-11-10 21:00:00'' ');
    writeln( 'problema : '+ r.GetByNameAsString('nid') );
    r:= ds.next;
  end;
end;
**)

end.


