unit uListaViolacionesPermitidasSimplex;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  xmatdefs, classes, uauxiliares;

type

  { TFichaViolacionPermitida }

  TFichaViolacionPermitida = class
    public
      //El indice en ivars de la próxima variable a violarle la cota en el simplex
      iViolacionAUsar: Integer;
      usada: boolean;
      ires: Integer;
      ivars: TDAofNInt;

      Constructor Create(xires : Integer; xivars: TDAofNInt);
      Constructor CreateFromXlt( var f: textfile );
      procedure WriteToXLT( var f: textfile );
  end;

  TListaViolacionesPermitidasSimplex = class(TList)
    public
      Constructor Create_Clone(listaOriginal : TListaViolacionesPermitidasSimplex);
      function sePuedeViolarCotaSupParaArreglar(xires: Integer; out
        ficha: TFichaViolacionPermitida): boolean;
      procedure Limpiar;
      procedure Free;
  end;

implementation

//-----------------------------------
//Métodos de TFichaViolacionPermitida
//===================================

constructor TFichaViolacionPermitida.Create(xires: Integer; xivars: TDAofNInt);
begin
  inherited Create;
  self.iViolacionAUsar:= 0;
//  self.ivar:= xivar;
  self.ires:= xires;
  self.ivars:= xivars;
  self.usada:= false;
end;

constructor TFichaViolacionPermitida.CreateFromXlt(var f: textfile);
var
  k, n: integer;
  r: string;
begin
  inherited Create;
  readln( f, r );
  iViolacionAUsar:= nextInt( r );
  usada:= IntToBool( nextint( r ) );
  ires:= nextInt( r );
  n:= nextint( r );
  setlength( ivars, n );
  for k:= 0 to high( ivars ) do
    ivars[k]:= nextInt(r );
end;

procedure TFichaViolacionPermitida.WriteToXLT(var f: textfile);
var
  k: integer;
begin
  write( f, iViolacionAUsar, #9, BoolToInt( usada ), #9, ires, #9 );
  write( f, length( ivars ) );
  for k:= 0 to high( ivars ) do
   write( f, #9, ivars[k] );
  writeln( f );
end;

//---------------------------------------------
//Métodos de TListaViolacionesPermitidasSimplex
//=============================================

Constructor TListaViolacionesPermitidasSimplex.Create_Clone(listaOriginal : TListaViolacionesPermitidasSimplex);
var
  i: Integer;
  fichaListaOrig: TFichaViolacionPermitida;
begin
  inherited Create;
  self.Capacity:= listaOriginal.Count;
  for i:= 0 to listaOriginal.Count -1 do
  begin
    fichaListaOrig:= listaOriginal.items[i];
    self.Add(TFichaViolacionPermitida.Create(fichaListaOrig.ires, fichaListaOrig.ivars));
  end;
end;

function TListaViolacionesPermitidasSimplex.sePuedeViolarCotaSupParaArreglar(xires : Integer; out ficha : TFichaViolacionPermitida) : boolean;
var
  i: Integer;
  res: boolean;
begin
  res:= false;
  ficha:= nil;
  for i:= 0 to Count -1 do
    if TFichaViolacionPermitida(items[i]).ires = xires then
    begin
      ficha:= items[i];
      res:= true;
      break;
    end;
  result:= res;
end;

procedure TListaViolacionesPermitidasSimplex.Limpiar;
var
  i: Integer;
begin
  for i:= 0 to count -1 do
    TFichaViolacionPermitida(items[i]).Free;
  self.Clear;
end;

procedure TListaViolacionesPermitidasSimplex.Free;
var
  i: Integer;
begin
  for i:= 0 to count -1 do
    TFichaViolacionPermitida(items[i]).Free;
  inherited Free;
end;

end.
