program listarclases;
(*
  busca en todos los archivos .pas y .pp las lineas que contengan
  la palabra "class(" y la escribe en consola
*)

uses
  Classes, SysUtils;

const
  xstrbuscar = 'class(';


function scanArchivo( const archi: string ): TStringList;
var
  r: string;
  f: textfile;
  ocurrencias: integer;
  ls: TStringList;

begin
  ls:= TStringList.Create;
  ocurrencias:= 0;
  assignfile( f, archi );
  filemode:= 0;
  reset( f );
  while not eof( f ) do
  begin
    readln( f, r );
    if pos( xstrbuscar, r ) > 0 then
    begin
      ls.add( r );
      inc( ocurrencias );
    end;
  end;
  closefile( f );
  result:= ls;
end;

procedure scanArchivos( const carpeta, xMascara: string);
var
  Dir: TSearchRec;
  archi: string;
  res: integer;
  ls: TStringList;
  k: integer;

begin
  res:= FindFirst( carpeta + DirectorySeparator +xMascara, faArchive, Dir);
  while ( res = 0) do
  begin
    if ((Dir.attr and faArchive) <> 0) then
    begin
      archi := carpeta + DirectorySeparator + Dir.Name;
      ls:= scanArchivo( archi );
      if ls.count > 0 then
      begin
        writeln('================================');
        writeln( archi );
        for k:= 0 to ls.count -1 do
           writeln( ls[k] );
        ls.Free;
      end;
    end;
    res:= FindNext(Dir);
  end;
  FindClose(Dir);
end;

procedure scanCarpetas( const carpeta: string);
var
  Dir: TSearchRec;
  res: integer;
begin
  res:= FindFirst(carpeta + DirectorySeparator + '*', faDirectory, Dir);
  while ( res = 0) do
  begin
     if ((Dir.attr and faDirectory) <> 0) and (Dir.Name[1] <> '.') and
      (Dir.Name <> 'backup') then
    begin
      scanCarpetas( carpeta + DirectorySeparator + Dir.Name );
    end;
    res:= FindNext(Dir);
  end;
  FindClose(Dir);
  scanArchivos( carpeta, '*.pas' );
  scanArchivos( carpeta, '*.pp' );
  scanArchivos( carpeta, '*.inc' );
end;


begin
  assignfile( output, '' );
  rewrite( output );
  if ParamCount > 0 then
    scanCarpetas( paramStr( 1 ) )
  else
    scanCarpetas( '.' );

  closefile( output );
end.

