unit uDatosNodo;

interface

uses
  xMatDefs, Classes,
{$IFDEF NETTOPOS_DLL}
  uimportnettopos,
{$ELSE}
  unettopos,
  unettopostypes,
  uglobsharedmem
{$ENDIF};

type
  //No es para ser instanciada directamente, las aplicaciones que lo precisen
  //puede crear subclases de esta para agregar informacin particular sobre
  //los nodos, por ejemplo para saber que clculos realizo
  //El forkAndJoin puede recibir como parametro una lista de TDatosNodo que el
  //despachador se encargara de actualizar al terminar el pedido de ejecucin
  TDatosNodo = class
    public
      nombre: String;      //Asignado por el despachador cuando se le asigna la lista de nodos
      idNodo: Cardinal;
      velocidad: NReal;    //por unidad de la tarea usada para medir la velocidad
                           //del nodo ejecutada por segundo
                           //=promedio(pesoRel / t)
      disponible: boolean; //el nodo se usara para ejecutar <=> si es true

      Constructor Create(idNodo: Cardinal);
      function toLinea: String; virtual;
  end;

  TConjuntoDeEjecucion = class(TList)
    public
      nNodosDisponibles: Integer;

      //Retorna un conjunto de ejecucion vacio
      Constructor Create; overload;
      //Retorna un conjunto de ejecucin con objetos de tipo TDatosNodo
      //creados a partir de idsNodos
      Constructor Create(idsNodos: TDAofNCardinal); overload;
      function getDatosNodo(idNodo: Cardinal): TDatosNodo;
      function getINodo(idNodo: Cardinal): Integer;
      function idNodos: TDAofNCardinal;
      procedure FreeConElementos;
  end;

implementation

//=====================
//Mtodos de TDatosNodo
//---------------------

Constructor TDatosNodo.Create(idNodo: Cardinal);
begin
  inherited Create;
  if idNodo = 0 then  
    self.idNodo:= unettopos.getIdNodoLocal
  else
    self.idNodo:= idNodo;
  self.disponible:= true;
  self.velocidad:= 1E-10;//Un valor bien chico pero distinto de 0 al incio, para
                         //que no afecte en la medicin 
end;

function TDatosNodo.toLinea: String;
begin
  result:= nombre;
end;

//============================
//Mtodos de TListaDeDatosNodo
//----------------------------

Constructor TConjuntoDeEjecucion.Create;
begin
  inherited Create;
end;

Constructor TConjuntoDeEjecucion.Create(idsNodos: TDAofNCardinal);
var
  i: Integer;
begin
  inherited Create;
  for i:= 0 to high(idsNodos) do
    add(TDatosNodo.Create(idsNodos[i]));
end;

function TConjuntoDeEjecucion.getDatosNodo(idNodo: Cardinal): TDatosNodo;
var
  i: Integer;
  res: TDatosNodo;
begin
  res:= NIL;
  //Si es el nodo local
  if (idNodo = 0) or (idNodo = 255) then
    idNodo:= unettopos.getIdNodoLocal;
  for i:= 0 to Count - 1 do
    if TDatosNodo(items[i]).idNodo = idNodo then
    begin
      res:= items[i];
      break;
    end;
  result:= res;
end;

function TConjuntoDeEjecucion.getINodo(idNodo: Cardinal): Integer;
var
  i, res: Integer;
begin
  res:= -1;
  //Si es el nodo local
  if (idNodo = 0) or (idNodo = 255) then
    idNodo:= unettopos.getIdNodoLocal;

  for i:= 0 to Count - 1 do
    if TDatosNodo(items[i]).idNodo = idNodo then
    begin
      res:= i;
      break;
    end;
  result:= res;
end;

function TConjuntoDeEjecucion.idNodos: TDAofNCardinal;
var
  res: TDAofNCardinal;
  i: Integer;
begin
  SetLength(res, Count);
  for i:= 0 to Count - 1 do
    res[i]:= TDatosNodo(items[i]).idNodo;
  result:= res;
end;

procedure TConjuntoDeEjecucion.FreeConElementos;
var
  i: Integer;
begin
  for i:= 0 to Count - 1 do
    TDatosNodo(Items[i]).Free;
  inherited Free;
end;

end.
