unit uMsgsDespachador;

interface

uses
{$IFDEF WIN32}
  Windows, Messages;
{$ELSE}
  uWinMsgs;
{$ENDIF}

const
  MAX_REINTENTOS_COMUNICACION = 3;

  MSGP_RECIBIR_RESPUESTA = WM_USER + 5000;

  //params: ninguno
  //retorna: estado: Cardinal;
  //Deben implementarlo los servicios que se provean en el nodo
  //Para ser llamado sincrono y con timeOut muy bajo. Responde 0 si no esta
  //haciendo nada, el idTarea de la tarea que esta procesando si esta haciendo algo
  MSGP_ESTADO = WM_USER * 2;

  ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL = -1;
  ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL = -2;
  ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER = -3;
  ERROR_CARGANDO_SALA = -4;
  ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA = -5;
  ERROR_NO_SE_PUDO_TRAER_LA_LISTA_DE_TOPOS = -6;
  ERROR_NO_SE_PUDO_LEVANTAR_LA_APLICACION = -7;
  ERROR_NO_SE_PUDO_TERMINAR_LA_APLICACION = -8;
  ERROR_NO_SE_ENCUENTRA_LA_TAREA = -9;
  ERROR_NO_SE_ENCUENTRA_EL_SERVICIO_EN_EJECUCION = -10;
  ERROR_TIMEOUT_VENCIDO_PARA_LA_TAREA = -11;
  ERROR_NO_SE_PUDO_PREGUNTAR_EL_ESTADO = -12;

function codErrorToString(codigo : Integer) : String;

implementation

function codErrorToString(codigo : Integer) : String;
begin
  case codigo of
    ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL : result:= 'ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL';
    ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL            : result:= 'ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL';
    ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER                        : result:= 'ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER';
    ERROR_CARGANDO_SALA                                          : result:= 'ERROR_CARGANDO_SALA';
    ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA                          : result:= 'ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA';
    ERROR_NO_SE_PUDO_TRAER_LA_LISTA_DE_TOPOS                     : result:= 'ERROR_NO_SE_PUDO_TRAER_LA_LISTA_DE_TOPOS';
    ERROR_NO_SE_PUDO_LEVANTAR_LA_APLICACION                      : result:= 'ERROR_NO_SE_PUDO_LEVANTAR_LA_APLICACION';
    ERROR_NO_SE_PUDO_TERMINAR_LA_APLICACION                      : result:= 'ERROR_NO_SE_PUDO_TERMINAR_LA_APLICACION';
    ERROR_NO_SE_ENCUENTRA_LA_TAREA                               : result:= 'ERROR_NO_SE_ENCUENTRA_LA_TAREA';
    ERROR_NO_SE_ENCUENTRA_EL_SERVICIO_EN_EJECUCION               : result:= 'ERROR_NO_SE_ENCUENTRA_EL_SERVICIO_EN_EJECUCION';
    ERROR_TIMEOUT_VENCIDO_PARA_LA_TAREA                          : result:= 'ERROR_TIMEOUT_VENCIDO_PARA_LA_TAREA';
    ERROR_NO_SE_PUDO_PREGUNTAR_EL_ESTADO                         : result:= 'ERROR_NO_SE_PUDO_PREGUNTAR_EL_ESTADO'
  else
    result:= 'Error Desconocido';
  end;
end;

end.
