unit timeLib;

interface

uses
  SysUtils;

function QueryPerformanceFrequency(var frec: Int64): LongBool;
function QueryPerformanceCounter(var counter: Int64): LongBool;

procedure test;

implementation

const
  nowToPerfCounter = 24 * 3600 * 1000;//Con esto se desprecia la precisin mas
                                      //alla de los milisegundos

function QueryPerformanceFrequency(var frec: Int64): LongBool;
begin
  frec:= 1000;
  QueryPerformanceFrequency:= True;
end;

function QueryPerformanceCounter(var counter: Int64): LongBool;
begin
  counter:= trunc(now() * nowToPerfCounter);
  QueryPerformanceCounter:= True;
end;

procedure test;
const
  tiempos : array [0..9] of Integer =  (1, 5, 10, 20, 50, 100, 200, 500, 1000, 5000);
var
  frec, ticksIni, ticksFin: Int64;
  invFrec: Double;
  i: Integer;
begin
  timeLib.QueryPerformanceFrequency(frec);
  invFrec:= 1000 / frec;

  for i:= low(tiempos) to high(tiempos) do
  begin
    write('sleep(',tiempos[i],')');
    timeLib.QueryPerformanceCounter(ticksIni);
    Sleep(tiempos[i]);
    timeLib.QueryPerformanceCounter(ticksFin);
    writeln(', medida= ', FloatToStrF((ticksFin - ticksIni) * invFrec, ffFixed, 8, 3), 'msecs');
  end;
end;

end.
