unit ukeydir;

interface

uses
  SysUtils, baseunix;

var
  keyBaseDir: String;

  keyArchiEventos, 
  keymtx_DlgSrvLine,
  keyNextNidLlamada,
  keyArchiLogs,
  keyArchiDBGLog,
  keymtx_ErrorLog,
  keyDlginterSharedMem,
  keyConfiguraciones,
  keyLineasTarjeta,
  keyGatillos,
  keySmfTopoTareasSincronas,
  keySmfPeticiones,
  keySmfAplics,
  keySmfNextNIDPeticion,
  keySmfDbgLog,
  keySmfErrLog,
  keySmfCntDBG,
  keySmfListaConexiones,
  keySmfConexion,
  keyColaMensajes: PChar;

procedure CrearArchiKey(const s: PChar );
procedure CrearArchiKeyString(const s: String );
// esto es por facilidad, para llamar una ves al instalar el entorno
procedure CrearArchivosKeys;

implementation

//retorna string1 + string2 como PCHar
function createPCharFromStrings(string1, string2: String): PChar;
var
  res: PChar;
  s: string;
begin
  s:= string1 + string2;
  GetMem(res, length(s) + 1);
  res:= StrPCopy(res, s);
  result:= res;
end;

procedure FreeAndNILPCHar(var s: PChar);
begin
  FreeMem(s, StrLen(s) + 1);
  s:= NIL;
end;

procedure initArchis;
var
  homeDir: String;
begin
  homeDir:= fpgetenv('HOME')+'/nettopos';
  //writeln('homeDir= ', homeDir);
  keyBaseDir:= homeDir + '/archikeys';
// SEMAFOROS -- camino a archivos KEY

{ Utilizada en uSignals.pas para la sealizacin
de las lneas con TEventTX y TEventRX. El cdigo
agregado es 100+nlina }
   keyArchiEventos:= createPCharFromStrings(keyBaseDir, '/keyEventos');

{ Utilizada en  dialogicsrv. El cdigo agregado
es nlinea. Se utiliza tanto por func_handler para
procesar eventos de la tarjeta como por la FORM
para respuesta a los mensajes enviados por la Dlginter }
   keymtx_DlgSrvLine:= createPCharFromStrings(keyBaseDir, '/keymtx_DlgSrvLine');

// Dlginter codigo 1
   keyNextNidLlamada:= createPCharFromStrings(keyBaseDir, '/keyNextNidLlamada');

{usado en ulog.log_nlin agregando 100, nlin de cdigo
La funcin log_nlin parece que no es utilizada por
nadie y or eso est comentada en la interface de ulog
}
   keyArchiLogs:= createPCharFromStrings(keyBaseDir, '/keyLogs');

// ulog con cdigo 1
   keyArchiDBGLog:= createPCharFromStrings(keyBaseDir, '/keyArchiLog');

// ulog codigo 1
   keymtx_ErrorLog:= createPCharFromStrings(keyBaseDir, '/keymtx_ErrorLog');


// SHARES de MEMORIA
   keyDlginterSharedMem:= createPCharFromStrings(keyBaseDir, '/keySharedMem');

// Key de configuraciones
   keyConfiguraciones:= createPCharFromStrings(keyBaseDir, '/keyConfigs');


// Key de lneas de la tarjeta
   keyLineasTarjeta:= createPCharFromStrings(keyBaseDir, '/keyLineasTarjetas');

// Key de gatillos
   keyGatillos:= createPCharFromStrings(keyBaseDir, '/keyGatillos');

   keySmfTopoTareasSincronas:= createPCharFromStrings(keyBaseDir, '/keySmfTopoTareasSincronas');
   keySmfPeticiones:= createPCharFromStrings(keyBaseDir, '/keySmfPeticiones');
   keySmfAplics:= createPCharFromStrings(keyBaseDir, '/keySmfAplics');
   keySmfNextNIDPeticion:= createPCharFromStrings(keyBaseDir, '/keySmfNextNIDPeticion');
   keySmfDbgLog:= createPCharFromStrings(keyBaseDir, '/keySmfArchiDbgLog');
   keySmfErrLog:= createPCharFromStrings(keyBaseDir, '/keySmfArchiErrLog');
   keySmfCntDBG:= createPCharFromStrings(keyBaseDir, '/keySmfCntDBG');
   keySmfListaConexiones:= createPCharFromStrings(keyBaseDir, '/keySmfListaConexiones');
   keySmfConexion:= createPCharFromStrings(keyBaseDir, '/keySmfConexion');
   keyColaMensajes:= createPCharFromStrings(keyBaseDir, '/keyColaMensajes');
end;

procedure CrearArchiKey(const s: PChar );
var
 f: textfile;
begin
  writeln('Creando archivo key ' + s);
  ForceDirectories(ExtractFilePath(s));
  AssignFile( f, s );
  Rewrite( f );
  writeln( f, 'ArchiKey: ',s,' - no borrar.' );
  closefile( f );
end;

procedure CrearArchiKeyString(const s: String );
var
 f: textfile;
begin
  writeln('Creando archivo key ' + s);
  ForceDirectories(ExtractFilePath(s));
  AssignFile( f, s );
  Rewrite( f );
  writeln( f, 'ArchiKey: ',s,' - no borrar.' );
  closefile( f );
end;

procedure CrearArchivosKeys;
begin
  crearArchiKey(keyArchiEventos);
  crearArchiKey(keymtx_DlgSrvLine);
  crearArchiKey(keyNextNidLlamada);
  crearArchiKey(keyArchiLogs);
  crearArchiKey(keyArchiDBGLog);
  crearArchiKey(keymtx_ErrorLog);
  crearArchiKey(keyDlginterSharedMem);
  crearArchiKey(keyConfiguraciones);
  crearArchiKey(keyLineasTarjeta);
  crearArchiKey(keyGatillos);
  crearArchiKey(keySmfTopoTareasSincronas);
  crearArchiKey(keySmfPeticiones);
  crearArchiKey(keySmfAplics);
  crearArchiKey(keySmfNextNIDPeticion);
  crearArchiKey(keySmfDbgLog);
  crearArchiKey(keySmfErrLog);
  crearArchiKey(keySmfCntDBG);
  crearArchiKey(keySmfListaConexiones);
  crearArchiKey(keySmfConexion);
  crearArchiKey(keyColaMensajes);
end;

procedure freeArchis;
begin
  FreeAndNILPCHar(keyArchiEventos);
  FreeAndNILPCHar(keymtx_DlgSrvLine);
  FreeAndNILPCHar(keyNextNidLlamada);
  FreeAndNILPCHar(keyArchiLogs);
  FreeAndNILPCHar(keyArchiDBGLog);
  FreeAndNILPCHar(keymtx_ErrorLog);
  FreeAndNILPCHar(keyDlginterSharedMem );
  FreeAndNILPCHar(keyConfiguraciones );
  FreeAndNILPCHar(keyLineasTarjeta );
  FreeAndNILPCHar(keyGatillos );
  FreeAndNILPCHar(keySmfTopoTareasSincronas );
  FreeAndNILPCHar(keySmfPeticiones );
  FreeAndNILPCHar(keySmfAplics );
  FreeAndNILPCHar(keySmfNextNIDPeticion );
  FreeAndNILPCHar(keySmfDbgLog );
  FreeAndNILPCHar(keySmfErrLog );
  FreeAndNILPCHar(keySmfCntDBG );
  FreeAndNILPCHar(keySmfListaConexiones );
  FreeAndNILPCHar(keySmfConexion );
  FreeAndNILPCHar(keyColaMensajes );
end;

initialization
  initArchis;

finalization
  freeArchis;

end.


