unit udemandaUTE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  gendefs;



type
   TDia= class
      dia, mes: integer;
      semana, tipo: integer;
      v: array[0..23] of double;
      constructor CreateReadFromText( var f: text );
      procedure WriteToText( var f: text );
      procedure WriteToXLTf( var f: TextFile; anio: integer; xTipo: integer );
      procedure WriteToBinSimSEEU( var f: file );
   end;

   TAnio= Class
      prox: TAnio;
      anio: integer;
      ndias: integer;
      valores: array of TDia;
      constructor readFromText( var f: TextFile );
      procedure writeToText( var f: TextFile );
      procedure WriteToXLTf( var f: TextFile );
      procedure WriteToBinSimSEEU( var f: file );
   end;

   TCargaHoraria = Class
      aecoIni, nAecos: integer;
      anios: array of TAnio;
      constructor CreateReadFromArchi( archi: string );
      procedure WriteToArchi( archi: string );
      procedure WriteToXLT( archi: string );
      procedure WriteToBinSimSEEU( archi: string );
   end;


type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Button2: TButton;
    eArchi: TEdit;
    eArchiSalida: TEdit;
    eAnioInicio: TEdit;
    eSemanaINicio: TEdit;
    ePotMW: TEdit;
    eSemanaFin: TEdit;
    eAnioFin: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Button3: TButton;
    Button4: TButton;
    Label7: TLabel;
    Button5: TButton;
    Button6: TButton;
    eSalSimSEEU: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
   Carga: TCargaHoraria;

  end;

var
  Form1: TForm1;

   ultimaSemana: integer;
   
implementation

{$R *.DFM}


function CantidadDeBisiestosHasta( anio: integer ): integer;
var
   m4, m100, m400: integer;
begin
   m4:= anio div 4;
   m100:= anio div 100;
   m400:= anio div 400;
   result:= m4-m100+m400;
end;


function EsBisiesto( anio: integer ): boolean;
begin
   result:= ((anio mod 4)=0)and((anio mod 100) <> 0) or ((anio mod 400)=0);
end;

function ndiasOfMes( mes, anio: integer): integer;
begin
  if mes = 2 then
  begin
    if EsBisiesto( anio ) then
      result:= 29
    else
      result:= 28
  end
  else
  begin
    if mes < 8 then
      mes:= mes+1;
    if (mes mod 2)=0 then
      result:= 31
    else
      result:= 30
  end;
end;

function nDiasOfAnio( anio: integer ): integer;
begin
   if EsBisiesto( anio ) then
      result:= 366
   else
      result:= 365;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  if  OpenDialog1.Execute then
  begin
      eArchi.Text:= OpenDialog1.FileName;
      eArchiSalida.Text:= eArchi.Text+'x';
  end;
end;


(*********************************************)
constructor TDia.CreateReadFromText( var f: text);
var
   r: string;
   ts, ts2: string;
   hora: integer;
begin
   readln( f, r );
   ts:=  nextpal( r);
   ts2:= copy(ts, length(ts)-1, 2 );
   delete( ts, length(ts)-1, 2 );
   dia:= StrToInt( ts2);

   ts2:= copy(ts, length(ts)-1, 2 );
   delete( ts, length(ts)-1, 2 );
   mes:= StrToInt( ts2 );

   ts:= nextpal( r );
   ts:= nextpal(r );
   semana:= nextInt(r );
   ts:= strAfter(r, ':' );
   tipo:= nextInt( ts );

   readln( f, r );
   for hora:= 0 to 11 do
      v[hora]:= nextFloat( r );

   readln( f, r );
   for hora:= 12 to 23 do
      v[hora]:= nextFloat( r );

end;


procedure TDia.WriteToXLTf( var f: TextFile; anio: integer; xTipo: integer );
var
   ts{, ts1}: string;
   hora: integer;
begin
{$IFDEF SOLOUNDATOPORSEMANA}
   if (semana <> ultimaSemana) and ( tipo= xTipo ) then
   begin
      ultimaSemana:= semana;
{$ENDIF}
      write( f, anio, #9, mes, #9, dia,  #9, semana, #9, tipo);
      for hora:= 0 to 23 do
      begin
         ts:= FloatToStr_( v[hora], 5, 0 );
         write(f, #9, ts );
      end;
      writeln( f, '' );
{$IFDEF SOLOUNDATOPORSEMANA}
   end;
{$ENDIF}
end;

procedure TDia.WriteToText( var f: text );
var
   ts, ts1: string;
   hora: integer;
begin
   ts:= IntToStr(dia);
   while length(ts) < 2 do ts:= '0'+ts;
   ts:= IntToStr(mes)+ts;
   while length(ts) < 6 do ts:= ' '+ts;
   ts:= ts+' SEMAINE NO ';
   ts1:= IntToStr(semana);
   while length(ts1) < 2 do ts1:= ' '+ts1;
   ts:= ts+ts1+' TYPE : '+IntToStr(tipo);
   writeln( f, ts );

   for hora:= 0 to 11 do
   begin
      ts:= FloatToStr_( v[hora], 5, 0 );
      write(f, ts, ' ' );
   end;
   writeln( f, '' );

   for hora:= 12 to 23 do
   begin
      ts:= FloatToStr_( v[hora], 5, 0 );
      write(f, ts, ' ' );
   end;
   writeln( f, '' );

end;

procedure TDia.WriteToBinSimSEEU( var f: file );
begin
   BlockWrite( f, v[0], 24* sizeOf( v[0] ));
end;

constructor TAnio.readFromText( var f: TextFile );
var
   k, kdia: integer;
   r: string;
   buscando: boolean;
begin
   buscando:= true;
   while buscando and not eof( f ) do
   begin
      readln(f, r );
      if pos('ANNE', r) > 0 then
         buscando:= false;
   end;

   if buscando then
   begin
      self:= nil;
      exit;
   end;

   readln( f, r );
   anio:= nextInt( r );

   system.writeln('Leyendo ao: ', anio );

  ndias:= NDiasOfAnio( anio );
  setlength( valores, ndias );

  for k:= 1 to 14 do
   readln( f, r );

  for kdia:= 0 to ndias-1 do
     valores[kdia]:= TDia.CreateReadFromText(f);

  try
     prox:= TAnio.readFromText( f );
  except
     prox:= nil;
  end;
end;


procedure TAnio.WriteToBinSimSEEU( var f: file );
var
   kdia: integer;
begin
   for kdia:= 0 to ndias-1 do
      valores[kdia].WriteToBinSimSEEU(f );
end;

procedure TAnio.WriteToXLTf( var f: TextFile );
var
   kdia: integer;
begin

   for kdia:= 0 to ndias-1 do
      valores[kdia].WriteToXLTf(f, anio, 1);

   writeln(f, '');
   writeln(f, '');

	 for kdia:= 0 to ndias-1 do
			valores[kdia].WriteToXLTf(f, anio, 2);
	 writeln(f, '');
	 writeln(f, '');

	 for kdia:= 0 to ndias-1 do
			valores[kdia].WriteToXLTf(f, anio, 3);

end;

procedure TAnio.writeToText( var f: TextFile );
var
	 kdia: integer;
begin

writeln(f,'********************************************************************************');
writeln(f,' CURVA DE CARGA -------------------------------------');
writeln(f,'');
writeln(f,'********************************************************************************');
writeln(f,' UNITE MW');
writeln(f,' VERSION  ?????');
writeln(f,'');
writeln(f,'********************************************************************************');
writeln(f,' ANNEE');
writeln(f, IntToStr_(anio,5) );
writeln(f,'********************************************************************************');
writeln(f,' FORMAT DE LECTURE D UNE LIGNE');
writeln(f,' (12(F5.0,1X))');
writeln(f,' NOMBRE DE PARAMETRES DE LECTURE:');
writeln(f,' 2');
writeln(f,' JOUR');
writeln(f,IntToStr_(ndiasOfAnio( anio ),5) );
writeln(f,' HEURES ');
writeln(f,'   24');
writeln(f,'');
writeln(f,'');
writeln(f,'********************************************************************************');
writeln(f,'');
writeln(f,'');
	 for kdia:= 0 to ndias-1 do
			valores[kdia].WriteToText(f);
end;



constructor TCargaHoraria.CreateReadFromArchi( archi: string );
var
   f: text;
   a, u: TAnio;
   kanio: integer;
begin
   assign( f, archi );
   reset( f );
   a:=  TAnio.readFromText(f);
   nAEcos:= 0;
   u:= a;
   while u <> nil do
   begin
      inc( nAEcos );
      u:= u.prox;
   end;
   setlength(anios, nAEcos );

   u:= a;
   kanio:= 0;
   aecoIni:= a.anio;
   while u <> nil do
   begin
      anios[kanio]:= u;
      inc( kanio );
			u:= u.prox;
	 end;
	 closeFile(f);
end;


procedure TCargaHoraria.WriteToXLT( archi: string );
var
	 f: text;
	 kanio: integer;

begin
	 assign( f, archi );
	 rewrite( f );
	 for kanio:= 0 to high( anios ) do
			anios[kanio].writeToXltf(f );
	 closeFile(f);
end;

procedure TCargaHoraria.WriteToBinSimSEEU( archi: string );
var
	 f: file;
	 kanio: integer;
	 FechaIni, FechaFin: TDateTime;
begin
	 FechaIni:= EncodeDate( Aecoini, 1, 1 );
	 FechaFin:= EncodeDate( AEcoIni+nAEcos-1, 12, 31)+EncodeTime(23, 59, 0, 0 );

	 assignfile( f, archi );
	 rewrite( f, 1 );

	 BlockWrite( f, FechaIni, Sizeof( FechaINi ));
	 BLockWrite( f, FechaFin, Sizeof( FechaFin ));

	 for kanio:= 0 to high( anios ) do
			anios[kanio].writeToBinSimSEEU(f );
	 closeFile(f);
end;


procedure TCargaHoraria.WriteToArchi( archi: string );
var
	 f: text;
	 kanio: integer;

begin
	 assign( f, archi );
	 rewrite( f );
	 for kanio:= 0 to high( anios ) do
			anios[kanio].writeToText(f);
   closeFile(f);
end;


procedure TForm1.Button2Click(Sender: TObject);

begin
   Carga:= TCargaHoraria.CreateReadFromArchi( eArchi.Text);

   eAnioInicio.Text:= IntToStr(  Carga.aecoIni );
   eAnioFin.text:= IntToStr( Carga.aecoIni+Carga.nAecos );
   eSemanaInicio.Text:= '1';
   eSemanaFin.Text:= '1';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   Carga.WriteToArchi( eArchiSalida.Text);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
   kanio, kdia, khora: integer;
   a: TAnio;
   d: TDia;
   kanioIni, kdiaIni: integer;
   kanioFin, kdiaFin: integer;
   potMW: double;
   activo: boolean;

begin

   kanioIni:= StrToInt(eAnioInicio.text)-Carga.aecoIni;
   kdiaIni:= ( StrToInt(eSemanaInicio.text) -1 )* 7;

   kanioFin:= StrToInt(eAnioFin.text)-Carga.aecoIni;
   kdiaFin:= ( StrToInt(eSemanaFin.text) -1 )* 7;

   activo:= false;

   potMW:= StrToFloat( ePotMW.text );
   for kanio:= 0 to Carga.nAecos-1 do
   begin
      a:= Carga.anios[kanio];
      for kdia:= 0 to a.ndias-1 do
      begin
         if not activo then
         begin
            if (kanioIni= kanio)and( kdia= kdiaIni) then
               activo:= true;
         end
         else
         begin
            if (kanio= kanioFin) and (kdia= kdiaFin) then
               activo:= false;
         end;

         if activo then
         begin
            d:= a.valores[kdia];
            for khora:= 0 to 16 do
               d.v[khora]:= d.v[khora] - potMW;
            for khora:= 22 to 23 do
               d.v[khora]:= d.v[khora] - potMW;
         end;
      end;
   end;
end;






procedure TForm1.Button5Click(Sender: TObject);
begin
   UltimaSemana:= -1;
   Carga.WriteToXlt( eArchiSalida.Text);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
   Carga.WriteToBinSimSEEU( eSalSimSEEU.text );
end;

end.

