unit uFichasFileManager;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  Classes, uMsgsFileManager, SysUtils;

type
  TEstadoArchivo = (ABIERTO_PARA_ESCRITURA, ABIERTO_PARA_LECTURA, SIN_ABRIR);

  TFichaArchivo = class
    private
    public
      f : File;
      ultimoError: Integer;
      dtUltimoPedido: TDateTime;
      hnd: Cardinal;
      tipoApertura: TEstadoArchivo;

      Constructor CreateWrite(hnd: Cardinal; nombreArch : String ; var result: boolean);
      Constructor CreateRead(hnd: Cardinal; nombreArch : String ; var result: boolean);

      //Cada una retorna si la operacion se realizo con xito o no. En caso contrario
      //ultimoError queda asignado con el ultimo error que haya sucedido.
      function EscribirDatos(pdatos: Pointer ; NBytesDatos : Integer ; var res: Integer) : boolean;
      function LeerDatos(var pdatos: Pointer ; Count : Integer; var NBytesDatos : Cardinal) : boolean;
      function CerrarArchivo : boolean;
      procedure Free;
  end;

implementation

Constructor TFichaArchivo.CreateWrite(hnd: Cardinal; nombreArch : String ; var result: boolean);
begin
  inherited Create;
  dtUltimoPedido:= Now;
  try
    self.hnd:= hnd;
    tipoApertura:= ABIERTO_PARA_ESCRITURA;
    AssignFile(f, nombreArch);
    Rewrite(f, 1);
    ultimoError:= 0;
    result:= true;
  Except
    result:= false;
  end;
end;

Constructor TFichaArchivo.CreateRead(hnd: Cardinal; nombreArch : String ; var result: boolean);
begin
  inherited Create;
  dtUltimoPedido:= Now;
  try
    self.hnd:= hnd;
    tipoApertura:= ABIERTO_PARA_LECTURA;
    AssignFile(f, nombreArch);
    Reset(f, 1);
    ultimoError:= 0;
    result:= true;
  Except
    result:= false;
  end;
end;

function TFichaArchivo.EscribirDatos(pdatos: Pointer ; NBytesDatos : Integer ; var res: Integer) : boolean;
begin
  dtUltimoPedido:= now;
  try
    BlockWrite(f, pdatos^, NBytesDatos, res);
    if res = NBytesDatos then
      result:= true
    else
    begin
      ultimoError:= ERROR_NO_SE_PUDO_ESCRIBIR_TODOS_LOS_DATOS;
      result:= false;
    end;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_ESCRIBIR_TODOS_LOS_DATOS;
    Result:= False;
  end;
end;

function TFichaArchivo.LeerDatos(var pdatos: Pointer ; Count : Integer; var NBytesDatos : Cardinal) : boolean;
begin
  dtUltimoPedido:= now;
  try
    BlockRead(f, pdatos, Count, NBytesDatos);
    result:= true;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_LEER_DEL_ARCHIVO;
    Result:= False;
  end;
end;

function TFichaArchivo.CerrarArchivo : boolean;
begin
  dtUltimoPedido:= now;
  try
    CloseFile(f);
    tipoApertura:= SIN_ABRIR;
    result:= true;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_CERRAR_EL_ARCHIVO;
    result:= false;
  end;
end;

procedure TFichaArchivo.Free;
begin
  if (tipoApertura = ABIERTO_PARA_ESCRITURA) or
     (tipoApertura = ABIERTO_PARA_LECTURA) then
  begin
    CloseFile(f);
  end;
  inherited Free;
end;

end.
