unit uFileManager;

interface

uses
  Classes, uMsgsFileManager, SysUtils, FileUtil;

type
//  TEstadoArchivo = (ABIERTO_PARA_ESCRITURA, ABIERTO_PARA_LECTURA, SIN_ABRIR);

  TFichaArchivoAbierto = class
    private
    public
//      tipoApertura : TEstadoArchivo;
      f : File;
      ultimoError: Integer;

      Constructor Create(nombreArch : String ; var result: boolean);

      //Cada una retorna si la operacion se realizo con xito o no. En caso contrario
      //ultimoError queda asignado con el ultimo error que haya sucedido.
      function AbrirArchivoParaLectura : boolean;
      function AbrirYReescribirArchivo : boolean;
      function EscribirDatos(pdatos: Pointer ; NBytesDatos : Cardinal) : boolean;
      function LeerDatos(var pdatos: Pointer ; var NBytesDatos : Cardinal) : boolean;
      function CerrarArchivo : boolean;
  end;

{procedure AbrirArchivoParaLectura;
procedure AbrirYReescribirArchivo;
procedure AbrirYConcatenarAArchivo;
procedure EscribirDatos;
procedure LeerDatos;
procedure CerrarArchivo;}

implementation

Constructor TFichaArchivoAbierto.Create(nombreArch : String ; var result: boolean);
begin
  inherited Create;
  try
    AssignFile(f, nombreArch);
//    tipoApertura:= SIN_ABRIR;
    ultimoError:= 0;
    result:= true;
  Except
    result:= false;
    ultimoError:= ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO;
  end;
end;

//Cada una retorna si la operacion se realizo con xito o no. En caso contrario
//ultimoError queda asignado con el ultimo error que haya sucedido.
function TFichaArchivoAbierto.AbrirArchivoParaLectura : boolean;
begin
  try
    Reset(f, 1);
//    tipoApertura:= ABIERTO_PARA_LECTURA;
    result:= true;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_ABRIR_EL_ARCHIVO_PARA_LECTURA;
    Result:= False;
  end;
end;

function TFichaArchivoAbierto.AbrirYReescribirArchivo : boolean;
begin
  try
    Rewrite(f, 1);
//    tipoApertura:= ABIERTO_PARA_ESCRITURA;
    result:= true;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_ABRIR_EL_ARCHIVO_PARA_ESCRITURA;
    Result:= False;
  end;
end;

function TFichaArchivoAbierto.EscribirDatos(pdatos: Pointer ; NBytesDatos : Cardinal) : boolean;
var
  res: Integer;
begin
  try
    rewrite(f,1);
    BlockWrite(f, pdatos, NBytesDatos, res);
    if res = NBytesDatos then
    begin
//    tipoApertura:= ABIERTO_PARA_ESCRITURA;
      result:= true;
    end
    else
    begin
      ultimoError:= ERROR_NO_SE_PUDO_ESCRIBIR_TODOS_LOS_DATOS;
      result:= false;
    end;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_ABRIR_EL_ARCHIVO_PARA_ESCRITURA;
    Result:= False;
  end;
end;

function TFichaArchivoAbierto.LeerDatos(var pdatos: Pointer ; var NBytesDatos : Cardinal) : boolean;
begin
  try
    BlockRead(f, pdatos, NBytesDatos);
    result:= true;
  Except
    ultimoError:= ERROR_NO_SE_PUDO_LEER_DEL_ARCHIVO;
    Result:= False;
  end;
end;

function TFichaArchivoAbierto.CerrarArchivo : boolean;
begin
  try
    CloseFile(f);
    result:= true;    
  Except
    ultimoError:= ERROR_NO_SE_PUDO_CERRAR_EL_ARCHIVO
  end;
end;



end.
