unit uMsgsFileManager;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFDEF WINDOWS}
	messages,
{$ELSE}
  uWinMsgs,
{$ENDIF}
  uconstantes_nettopos;

const
  AppName = 'FileManager';

  ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO_PARA_LECTURA = -1;
  ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO_PARA_ESCRITURA = -2;
  ERROR_NO_SE_PUDO_ESCRIBIR_TODOS_LOS_DATOS = -3;
  ERROR_NO_SE_PUDO_LEER_DEL_ARCHIVO = -4;
  ERROR_NO_SE_PUDO_CERRAR_EL_ARCHIVO = -5;
  ERROR_NO_SE_ASIGNO_EL_ARCHIVO = -6;
  ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL = -7;
  ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL = -8;

  //Constantes NUEVAS!!!

  ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO = -9;
  ERROR_NO_SE_PUDO_ABRIR_EL_ARCHIVO_PARA_LECTURA = -10;
  ERROR_NO_SE_PUDO_ABRIR_EL_ARCHIVO_PARA_ESCRITURA = -11;

  //params: nomArch: PChar;
  //retorna: resultado: Cardinal, codError: Integer
  //resultado es 0 si fallo, el el handle del archivo en caso contrario
  MSGP_OPENWRITE = WM_USER + 1;

  //params: nomArch: PChar;
  //retorna: resultado: Cardinal, codError: Integer
  //resultado es 0 si fallo, el el handle del archivo en caso contrario
  MSGP_OPENREAD = WM_USER + 2;

  //params: handle: Cardinal,
  //        NBytesDatos: Integer,
  //        pdatos: Pointer
  //handle es el retornado por openwrite, nBytesDatos es la cantidad de bytes
  //a copiar desde pdatos
  //retorna: resultado: Cardinal, codError: Integer
  //resultado es 0 si fallo, el el handle del archivo en caso contrario
  MSGP_WRITE = WM_USER + 3;

  //params: handle: Cardinal
  //handle es el retornado por openread
  //retorna: resultado: Cardinal, codError: Integer, NBytesLeidos: Integer, pdatos: Pointer
  //resultado es 0 si fallo, el el handle del archivo en caso contrario
  //NBytesLeidos es la cantidad de Bytes validos a partir de pdatos
  MSGP_READ = WM_USER + 4;

  //params: handle: Cardinal
  //handle es el retornado por openread u openwrite
  //retorna: resultado: Cardinal, codError: Integer
  //resultado es 0 si fallo, el el handle del archivo en caso contrario
  MSGP_CLOSEFILE = WM_USER + 5;

  //params: nomArch: PChar;
  //retorna: resultado: Cardinal
  //resultado es 0 si el archivo no existe, 1 si si
  MSGP_FILEEXISTS = WM_USER + 6;

  //params: nomArch: String;
  //        md5: String;
  //retorna: resultado: Integer
  //resultado es: 0 si el archivo no existe o no es el mismo que en el nodo de origen
  //              1 si existe y es el mismo que en el nodo de origen
  //codError es: 0 si el archivo no existe
  //             -1 si existe pero es distinto que en el nodo origen
  //             los errores de comunicacin de la dll en caso de producirse algunos
  MSGP_SAMEFILEEXISTS = WM_USER + 7;

  MSGR_OPENWRITE = WM_USER + 8;
  MSGR_OPENREAD = WM_USER + 9;
  MSGR_WRITE = WM_USER + 10;
  MSGR_READ = WM_USER + 11;
  MSGR_CLOSEFILE = WM_USER + 12;
  MSGR_FILEEXISTS = WM_USER + 13;
  MSGR_SAMEFILEEXISTS = WM_USER + 14;

  //Tamao del buffer a usar para transferir archivos
  RecommendedBufferSize = 1024 * 1024 + sizeOf(Cardinal) + sizeOf(Integer);

type
  PRespuesta= ^TRespuesta;
  TRespuesta = packed record
    resultado: Cardinal;
    msj_Error: Integer;
    NBytesDatos: Cardinal;
    datos: Pointer;
  end;


  PPregunta = ^TPregunta;
  TPregunta = packed record
    handle: Cardinal;
    NBytesDatos: Integer;
    datos: array[0..1024*1024*1024] of byte;
  end;

//Convierte un path a path de Netopos
//Quita la raiz y si no lo tiene concatena al principio dirbase
procedure toNetoposPath(var path: String);

function codErrorToString(codigo : Integer) : String;

implementation

procedure toNetoposPath(var path: String);
var
  posDosPuntos: Integer;
begin
  posDosPuntos:= Pos(':', path);
  if posDosPuntos = 1 then  //Saco unidad:, dejo la \
    delete(path, 1, posDosPuntos);

  if Pos(uconstantes_nettopos.dirbase, path) <> 1 then
    if path[1] = DirectorySeparator then
      path:= uconstantes_nettopos.dirbase + path
    else
      path:= uconstantes_nettopos.dirbase + DirectorySeparator + path;
end;

function codErrorToString(codigo : Integer) : String;
begin
  case codigo of
    ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO_PARA_LECTURA              : result:= 'ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO_PARA_LECTURA';
    ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO_PARA_ESCRITURA            : result:= 'ERROR_NO_SE_PUDO_ASIGNAR_EL_ARCHIVO_PARA_ESCRITURA';
    ERROR_NO_SE_PUDO_ESCRIBIR_TODOS_LOS_DATOS                     : result:= 'ERROR_NO_SE_PUDO_ESCRIBIR_TODOS_LOS_DATOS';
    ERROR_NO_SE_PUDO_LEER_DEL_ARCHIVO                             : result:= 'ERROR_NO_SE_PUDO_LEER_DEL_ARCHIVO';
    ERROR_NO_SE_PUDO_CERRAR_EL_ARCHIVO                            : result:= 'ERROR_NO_SE_PUDO_CERRAR_EL_ARCHIVO';
    ERROR_NO_SE_ASIGNO_EL_ARCHIVO                                 : result:= 'ERROR_NO_SE_ASIGNO_EL_ARCHIVO';
    ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL             : result:= 'ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL';
    ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL  : result:= 'ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL';
  else
    result:= 'Error Desconocido'; 
  end;
end;

end.
