unit uMsgsOptDisV2;

interface

uses
  ubuffrw,
{$IFDEF WINDOWS}
  messages;
{$ELSE}
  uWinMsgs;
{$ENDIF}

const
  AppName = 'OptDisV2';
  tipoCompresionReales = ToWord;

  //params: archiSala: String;
  //retorna: codRespuesta: Integer;
  //         [msjError: String]
  //Para ser llamado asincrono. Carga la sala en uconstantes.dirbase\archiSala
  //y le llama el procedimiento inicializarOptimizacion
  //codRespuesta es 0 si fallo, 1 en caso contrario
  //msjError es el mensaje de error retornado por la sala en caso de haber
  //fallado
  MSGP_CARGAR_E_INICIALIZAR_SALA = WM_USER + 1;

  //params: estrellaIni, estrellaFin: Integer;
  //retorna: costosFuturos: TDAOfNReal;
  //Para ser llamado asincrono. Calcula los valores de los costosFuturos para
  //las estrellas en el rango [estrellaIni, estrellaFin]
  //Cuando termina de calcular el rango avisa que termino y retorna los valores
  //de los costosFuturos para las estrellas en el rango [estrellaIni, estrellaFin]
  MSGP_CALCULAR_RANGO_ESTRELLAS = WM_USER + 2;

  //params: estrellaIni: Integer;
  //        costosFuturos: TDAOfNReal;
  //retorna: codRespuesta: Integer
  //Para ser llamado asincrono. Copia los valores de costosFuturos en la
  //funcin de costo futuro a partir de estrellaIni
  //Cuando termina de actualizar el rango avisa que termino.
  //codRespuesta es 0 si fallo, 1 en caso contrario
  MSGP_LLENAR_RANGO_ESTRELLAS = WM_USER + 3;

  //params: estrellaIni, estrellaFin: Integer;
  //retorna: costosFuturos: TDAOfNReal;
  //Para ser llamado asincrono. Retorna los valores de los costosFuturos para
  //las estrellas en el rango [estrellaIni, estrellaFin]
  MSGP_GET_RANGO_ESTRELLAS = WM_USER + 4;

  //params: lparam: Integer
  //retorna: codRespuesta: Integer
  //         pasoResultante: Integer
  //lparam debe contener el paso que me piden avanzar
  //Para ser llamado asincrono. Si la sala esta optimizando y en un paso mayor
  //o igual que al que me piden avanzar o simulando y en un paso menor va al paso
  //indicado y retorna codRespuesta = 1 y el paso en que quede la sala
  //sino retorna codRespuesta = 0, no cambia el paso de la sala y lo devuelve
  MSGP_DAR_PASO = WM_USER + 5;

  //params: lparam: Integer;
  //        nRangos: Integer;
  //        estrellaIni: Integer;       Vienen nRangos veces
  //        costosFuturos: TDAOfNReal;
  //retorna: codRespuesta: Integer
  //         pasoResultante: Integer
  //Para ser llamado asincrono. Copia los valores de costosFuturos en la
  //funcin de costo futuro a partir de estrellaIni para los nRangos que le
  //vengan cuando termina de actualizar los rangos avisa avanza el paso a lparam
  //-1
  //codRespuesta es:
  //si la sala esta en un paso mayor o igual que kpaso, copia los valores en
  //el costo futuro de lparam, queda en el paso lparam -1 y retorna 1
  //si la sala esta en un paso menor que lparam no copia los valores,
  //queda en el paso que estaba y retorna 0
  //pasoResultante es el paso en que quedo la sala luego de la llamada
  MSGP_LLENAR_RANGOS_Y_DAR_PASO = WM_USER + 6;

  //params: lparam: Integer;
  //        nRangos: Integer;
  //        estrellaIniLLenar: Integer;       ]Vienen nRangos veces
  //        costosFuturos: TDAOfNReal;        ]
  //        estrellaIniCalc, estrellaFinCalc: Integer;
  //retorna: codRespuesta: Integer;
  //         pasoResultante: Integer;
  //         costosFuturos: TDAOfNReal;
  //Para ser llamado asincrono. Copia los valores de costosFuturos en la
  //funcin de costo futuro a partir de estrellaIni para los nRangos que le
  //vengan cuando termina de actualizar los rangos avanza el paso a lparam - 1 y
  //calcula las estrellas en el rango [estrellaIniCalc, estrellaFinCalc]
  //lparam es el paso de tiempo para el que se pide llenar el rango
  //si la sala esta en un paso mayor o igual que lparam, copia los valores en
  //el costo futuro de lparam, sino los ignora
  //luego indica a la sala ir al paso lparam - 1 y calcula los costos futuros
  //para las estrellas en el rango [estrellaIniCalc, estrellaFinCalc] para el paso
  //lparam - 1
  //codRespuesta es:
  //1 si el paso de la sala es mayor que lparam - 1  (avance hasta lparam - 1),
  //2 si el paso de la sala era igual que lparam - 1 (quedo en donde estaba),
  //0 si la sala esta en un paso menor que lparam    (estoy mas adelante que lo que me piden)
  //pasoResultante es el paso en que quedo la sala luego de la llamada
  //costosFuturos es los valores de los costosFuturos para las estrellas en el
  //rango [estrellaIniCalc, estrellaFinCalc]
  MSGP_LLENAR_RANGO_DAR_PASO_Y_CALCULAR_RANGO = WM_USER + 7;

  //params: ninguno
  //retorna: glma: TDAOfNReal;
  //         glinext: Integer;
  //         glinextp: Integer;
  //Retorna los valores de glma, glinext y glinextp de la fuente MadreUniforme
  //en globs de la sala. En el caso multihilo estos valores deben ser iguales
  //para cada hilo, retorna los del hilo principal
  MSGP_GET_ESTADO_MADRE_UNIFORME = WM_USER + 8;

  //params: glma: TDAOfNReal;
  //        glinext: Integer;
  //        glinextp: Integer;
  //retorna: codRespuesta
  //Fija los valores de glma, glinext y glinextp de la fuente MadreUniforme
  //en globs de la sala. En el caso multihilo estos valores deben ser iguales
  //para cada hilo, fija los valores para la fuente de cada hilo.
  //codRespuesta es 0 si hubo algun problema, 1 en caso contrario
  MSGP_SET_ESTADO_MADRE_UNIFORME = WM_USER + 9;


  MSGR_CARGAR_E_INICIALIZAR_SALA = WM_USER + 10;
  MSGR_CALCULAR_RANGO_ESTRELLAS = WM_USER + 11;
  MSGR_LLENAR_RANGO_ESTRELLAS = WM_USER + 12;
  MSGR_GET_RANGO_ESTRELLAS = WM_USER + 13;
  MSGR_DAR_PASO = WM_USER + 14;
  MSGR_LLENAR_RANGOS_Y_DAR_PASO = WM_USER + 15;
  MSGR_LLENAR_RANGO_DAR_PASO_Y_CALCULAR_RANGO = WM_USER + 16;
  MSGR_GET_ESTADO_MADRE_UNIFORME = WM_USER + 17;
  MSGR_SET_ESTADO_MADRE_UNIFORME = WM_USER + 18;

  ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL = -1;
  ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL = -2;
  ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER = -3;
  ERROR_CARGANDO_SALA = -4;
  ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA = -5;

function codErrorToString(codigo : Integer) : String;

implementation

function codErrorToString(codigo : Integer) : String;
begin
  case codigo of
    ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL : result:= 'ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL';
    ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL : result:= 'ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL';
    ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER : result:= 'ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER';
    ERROR_CARGANDO_SALA : result:= 'ERROR_CARGANDO_SALA';
    ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA : result:= 'ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA';
  else
    result:= 'Error Desconocido';
  end;
end;

end.
