unit uDatosNodoOptDisV2;

interface

uses
  uDatosNodo, uRangos;

type

  TDatosNodoOptDisV2 = class(TDatosNodo)
    public
      pasoEnElQueSeEncuentra: Integer;
      rangosCalculados: TListaDeRangos;

      Constructor Create(idNodo: Cardinal; nPasos, minEstrellaSala, maxEstrellaSala: Integer);
      procedure Free;
  end;

implementation

Constructor TDatosNodoOptDisV2.Create(idNodo: Cardinal; nPasos, minEstrellaSala, maxEstrellaSala: Integer);
begin
  inherited Create(idNodo);
  self.pasoEnElQueSeEncuentra:= nPasos;
  self.rangosCalculados:= TListaDeRangos.Create(minEstrellaSala, maxEstrellaSala);
end;

procedure TDatosNodoOptDisV2.Free;
begin
  rangosCalculados.Free;
  inherited Free;
end;

end.
