unit uMsgsOrquestadorV2;

interface

uses
{$IFDEF WINDOWS}
	messages;
{$ELSE}
  uWinMsgs;
{$ENDIF}

const
  AppName = 'OrquestadorV2';

{  //params: estrellaIni, estrellaFin: Integer;
  //retorna: codRespuesta;
  //Para ser llamado asincrono. Calcula los valores de los costosFuturos para
  //las estrellas en el rango [estrellaIni, estrellaFin]
  //Cuando termina de calcular el rango avisa que termino.
  //codRespuesta es 0 si fallo, 1 en caso contrario
  MSGP_CALCULAR_RANGO_ESTRELLAS = WM_USER + 1;

  //params: estrellaIni: Integer;
  //        costosFuturos: TDAOfNReal;
  //retorna: codRespuesta: Integer
  //Para ser llamado asincrono. Copia los valores de costosFuturos en la
  //funcin de costo futuro a partir de estrellaIni
  //Cuando termina de actualizar el rango avisa que termino.
  //codRespuesta es 0 si fallo, 1 en caso contrario
  MSGP_LLENAR_RANGO_ESTRELLAS = WM_USER + 2;

  //params: estrellaIni, estrellaFin: Integer;
  //retorna: costosFuturos: TDAOfNReal;
  //Para ser llamado asincrono. Retorna los valores de los costosFuturos para
  //las estrellas en el rango [estrellaIni, estrellaFin]
  MSGP_GET_RANGO_ESTRELLAS = WM_USER + 3;

  //params: ninguno
  //retorna: codRespuesta: Integer
  //Para ser llamado asincrono. Cuando termina de avanzar el paso avisa que
  //termino. codRespuesta es 0 si fallo, 1 en caso contrario
  MSGP_DAR_PASO = WM_USER + 4;

  MSGR_CALCULAR_RANGO_ESTRELLAS = WM_USER + 5;
  MSGR_LLENAR_RANGO_ESTRELLAS = WM_USER + 6;
  MSGR_GET_RANGO_ESTRELLAS = WM_USER + 7;}
  MSGR_DAR_PASO = WM_USER + 8;

  ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL = -1;
  ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL = -2;
  ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER = -3;
  ERROR_CARGANDO_SALA = -4;
  ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA = -5;
  ERROR_NO_SE_PUDO_TRAER_LA_LISTA_DE_TOPOS = -6;
  ERROR_NO_SE_PUDO_LEVANTAR_LA_APLICACION = -7;
  ERROR_NO_SE_PUDO_TERMINAR_LA_APLICACION = -8;  

function codErrorToString(codigo : Integer) : String;

implementation

function codErrorToString(codigo : Integer) : String;
begin
  case codigo of
    ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL : result:= 'ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL';
    ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL : result:= 'ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL';
    ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER : result:= 'ERROR_QUEDAN_REFERENCIAS_SIN_RESOLVER';
    ERROR_CARGANDO_SALA : result:= 'ERROR_CARGANDO_SALA';
    ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA : result:= 'ERROR_NO_SE_PUDO_COMUNICAR_LA_TAREA';
    ERROR_NO_SE_PUDO_TRAER_LA_LISTA_DE_TOPOS : result:= 'ERROR_NO_SE_PUDO_TRAER_LA_LISTA_DE_TOPOS';
    ERROR_NO_SE_PUDO_LEVANTAR_LA_APLICACION : result:= 'ERROR_NO_SE_PUDO_LEVANTAR_LA_APLICACION';
    ERROR_NO_SE_PUDO_TERMINAR_LA_APLICACION : result:= 'ERROR_NO_SE_PUDO_TERMINAR_LA_APLICACION';
  else
    result:= 'Error Desconocido';
  end;
end;

end.
