unit uTestTiempos;

interface

uses
  uAuxiliares, SysUtils;

procedure procesarArchi(arch: String);
procedure run;

implementation

procedure procesarArchi(arch: String);
var
  ts: array [1..10000] of Double;
  nMuestras: array [1..10000] of Integer;
  val: Double;
  i: Integer;
  linea: String;
  f, fsal: Textfile;
  nomSal: String;
begin
  AssignFile(f, arch);
  reset(f);
  for i:= 1 to high(ts) do
  begin
    ts[i]:= 0;
    nMuestras[i]:= 0;
  end;

  while not eof(f) do
  begin
    Readln(f, linea);
    i:= Trunc(NextFloat(linea));
    if nMuestras[i] = 0 then
    begin
      ts[i]:= NextFloat(linea);
      nMuestras[i]:= 1;
    end
    else
    begin
      val:= NextFloat(linea);
      ts[i]:= (ts[i] * nMuestras[i] + val) / (nMuestras[i] + 1);
      nMuestras[i]:= nMuestras[i] + 1;
    end;
  end;
  CloseFile(f);

  i:= pos('.', arch);
  nomSal:= Copy(arch, 1, i - 1) + 'sal.txt';
  AssignFile(fsal, nomSal);
  rewrite(fsal);
  for i:= 1 to high(ts) do
  begin
    if nmuestras[i] <> 0 then
      writeln(fsal, i, #9, FloatToStrF(ts[i], ffFixed, 10, 8), #9, nMuestras[i]);
  end;
  CloseFile(fsal);
end;

procedure run;
begin
  procesarArchi('t_ActualizarLocal.txt');
  procesarArchi('t_ActualizarRemoto.txt');
  procesarArchi('t_CalcDevolver.xlt');
end;

end.
