unit uConstantesConector;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFDEF WINDOWS}
messages, FileUtil,
{$ELSE}
  uWinMsgs,
{$ENDIF}
  Classes, uconstantes_nettopos, uheapmanager, ubuffrw, uConstantesSimSEE,
  SysUtils, zipper, xMatDefs, unettopostypes;

const

  MAX_INTENTOS_NODO_NO_CONTESTO = 2;

  MAX_NBYTES_POR_ENVIO = uheapmanager.CMaxHeapSize;

  MSGP_NOTIFICAR_WK_ON = WM_USER + 1;
  MSGP_NOTIFICAR_WK_OFF = WM_USER + 2;

  MSGP_NOTIFICAR_TAREAS_SIN_RESOLVER = WM_USER + 3;
  MSGR_NOTIFICAR_TAREAS_SIN_RESOLVER = MSGP_NOTIFICAR_TAREAS_SIN_RESOLVER + 2000;


procedure meterDatosAContinuacion (var buff1:TBuffReader; buff2:TBuffReader);


procedure invertirComunicado(var comunicado: TFichaComunicado);


implementation

procedure meterDatosAContinuacion(var buff1: TBuffReader; buff2: TBuffReader);
var
  px:PByte;
begin
  ReAllocMem(buff1.pBuff, buff1.tamBuff+buff2.tamBuff);
  px := buff1.pBuff;
  inc(px,buff1.tamBuff+1);
  move(buff2.pBuff, px, buff2.tamBuff);
  buff2.Free;
end;


procedure invertirComunicado(var comunicado: TFichaComunicado);
var
  aux_Swap: Cardinal;
begin
  aux_Swap:= comunicado.idNodoOrigen;
  comunicado.idNodoOrigen:= comunicado.idNodoDestino;
  comunicado.idNodoDestino:= aux_Swap;

  aux_Swap:= comunicado.idOrigen;
  comunicado.idOrigen:= comunicado.idDestino;
  comunicado.idDestino:= aux_Swap;
end;



end.

