unit uNodosDeCalculo;

{$mode delphi}

interface

uses
  Classes, SysUtils, urosx,
  uDataSetGenerico,
  unettopos, unettopostypes, uglobsharedmem,
  uconstantes_nettopos;

type

  { TNodoCalculo }

  TNodoCalculo=class

    _nid: Integer;
    _idnodo:Cardinal;
    _topo:Cardinal;
    _idaplic: Cardinal;
    _nid_problema: Integer;
    _soy_master: Boolean;
    _nombre: String;
    _estado: Integer;

    nFallos: Integer;

    constructor Crear (nid: Integer; nodo:Cardinal; topo:Cardinal; idaplic: Cardinal;
                       nid_problema: Integer; soy_master: Boolean; nombre: String; estado: Integer);

    constructor createFromServer (nodo:Cardinal; idaplic: Cardinal);
    function incFallos:Integer;

    //Estados del jugador.
    // 0 : OffLine
    // 1 : Disponible
    // 2 : Trabajando
    // 3 : Libre
    function setEstado (e: Integer): Boolean;

    procedure notificar (codMsg: Integer);

  end;

  { TListaDeNodosCalculo }

  TListaDeNodosCalculo=class(TList)
    function GetAplicsFromServer(nid_problema: Integer; estado: Integer):Boolean;
    function Add(Item: TNodoCalculo): Integer;
    function Get(Index: Integer): TNodoCalculo;
    function GetIndexByNID(nid: Integer): Integer;
    function GetIndexByIdAplic(idNodo, idAplic: Cardinal): Integer;
  end;


implementation

{ TListaDeNodosCalculo }

function TListaDeNodosCalculo.GetAplicsFromServer(nid_problema: Integer;
  estado: Integer): Boolean;
var
  ds: TResultadoQuery;
  rec: TDataRecord;

  nid: Integer;
  nodo:Cardinal;
  topo:Cardinal;
  idaplic: Cardinal;
  nid_problema_: Integer;
  soy_master: Boolean;
  nombre: String;
  estado_: Integer;


begin
 result:=true;
 ds:= sql_query('SELECT * from clt_aplics_problema WHERE ( estado='+IntToStr(estado)+
                ' AND nid_problema='+IntToStr(nid_problema)+')');
 rec := ds.next;
 if rec = nil then
  result:= false
 else
  while rec <> nil do
    begin
      nid:=rec.GetByNameAsInt('nid');
      nodo:= IP4StrToCardinal(rec.GetByNameAsString('nodo'));
      topo:= rec.GetByNameAsInt('topo');
      idaplic:= rec.GetByNameAsInt('idaplic');
      nid_problema_:= rec.GetByNameAsInt('nid_problema');
      nombre:= rec.GetByNameAsString('nombre');
      estado_:= rec.GetByNameAsInt('estado');
      if rec.GetByNameAsInt('estado') = 1 then
       soy_master:=True
      else
       soy_master:=False;

      self.Add(TNodoCalculo.Crear(nid, nodo, topo, idaplic, nid_problema_,
                               soy_master, nombre, estado_));
      rec:= ds.next;
    end;

 ds.Free;

end;

function TListaDeNodosCalculo.Add(Item: TNodoCalculo): Integer;
begin
  Result:=inherited Add(Item);
end;

function TListaDeNodosCalculo.Get(Index: Integer): TNodoCalculo;
begin
   Result := TNodoCalculo(Items[Index]);
end;

function TListaDeNodosCalculo.GetIndexByNID(nid: Integer): Integer;
var
  i:Integer;
  j: TNodoCalculo;
begin
  result := -1;
  for i := 0 to self.Count-1 do
    begin
      j:=Get(i);
      if j._nid= nid then
        begin
          Break;
          result:=i;
        end;
    end;
end;

function TListaDeNodosCalculo.GetIndexByIdAplic(idNodo, idAplic: Cardinal
  ): Integer;
var
  i:Integer;
  j: TNodoCalculo;
begin
  result := -1;
  for i := 0 to self.Count-1 do
    begin
      j:=Get(i);
      if ((j._idnodo=idNodo) AND (j._idaplic=idAplic)) then
        begin
          Break;
          result:=i;
        end;
    end;
end;


{ TNodoCalculo }

constructor TNodoCalculo.Crear(nid: Integer; nodo: Cardinal; topo: Cardinal;
  idaplic: Cardinal; nid_problema: Integer; soy_master: Boolean;
  nombre: String; estado: Integer);
begin
    _nid:= nid;
    _idnodo:= nodo;
    _topo:= topo;
    _idaplic:=idaplic;
    _nid_problema:=nid_problema;
    _soy_master:=soy_master;
    _nombre:= nombre;
    _estado:= estado;

    nFallos:=0;
end;

constructor TNodoCalculo.createFromServer(nodo: Cardinal; idaplic: Cardinal);
var
  ds: TResultadoQuery;
  rec: TDataRecord;

begin
 ds:= sql_query('SELECT * from clt_aplics_problema WHERE ( idaplic='+IntToStr(idaplic)+
                ' AND nodo='''+CardinalToIP4Str(nodo)+''')');
 rec := ds.next;
 if rec = nil then
  begin
    self := nil;
  end
 else
  begin
      _nid:=rec.GetByNameAsInt('nid');
      _idnodo:= IP4StrToCardinal(rec.GetByNameAsString('nodo'));
      _topo:= rec.GetByNameAsInt('topo');
      _idaplic:= rec.GetByNameAsInt('idaplic');
      _nid_problema:= rec.GetByNameAsInt('nid_problema');
      _nombre:= rec.GetByNameAsString('nombre');
      _estado:= rec.GetByNameAsInt('estado');
      if rec.GetByNameAsInt('estado') = 1 then
       _soy_master:=True
      else
       _soy_master:=False;

  end;

 ds.Free;

end;

function TNodoCalculo.incFallos: Integer;
begin
  nFallos:=nFallos+1;
  result := nFallos;
end;

function TNodoCalculo.setEstado(e: Integer): Boolean;
begin

  result:=sql_exec('UPDATE clt_aplics_problema SET (estado, dt_ultimo_contacto) VALUES '+
                  '('+IntToStr(e)+', now() )');

end;

procedure TNodoCalculo.notificar(codMsg: Integer);
var
  fc:TFichaComunicado;
begin

  fc.idNodoOrigen := pm^.idNodoLocal;
  fc.idOrigen:=idAplicYo;
  fc.idNodoDestino:=self._idnodo;
  fc.idDestino:=self._idaplic;
  fc.codigoMsg:=codMsg;
  fc.idTarea:=0;
  fc.nBytesDatos:=0;
  comunicar(@fc, nil, timeOutComsCte);
end;

end.

