unit uMsgsTestNettopos;

interface

uses
{$IFDEF LINUX}
  uWinMsgs;
{$ELSE}
  messages;
{$ENDIF}

const
  AppName = 'TestNettopos';

  //params: x: Integer
  //retorna: res: Integer;
  //Recibe el comunicado enviado y lo devuelve con el valor de x multiplicado por 2
  //Si se pide sincrono la respuesta es inmediata, sino la aplicacion que pide
  //la tarea debe declarar un procedimiento para esperar el mensaje MSGR_PEDIRX2
  MSGP_PEDIRX2 = WM_USER + 1;
  MSGR_PEDIRX2 = WM_USER + 2;


  //params: s: String
  //retorna: nBytesRecibidos: Cardinal
  //Recibe el comunicado e imprime en pantalla el valor de s, devuelve una respuesta
  //con el tamao del s que recibi
  //Si se pide sincrono la respuesta es inmediata, sino la aplicacion que pide
  //la tarea debe declarar un procedimiento para esperar el mensaje MSGR_TESTMEMOADD
  MSGP_TESTMEMOADD = WM_USER + 3;
  MSGR_TESTMEMOADD = WM_USER + 4;

  //params: s: String
  //        paraTestearDespachador: boolean
  //retorna: res: String
  //Recibe una string y la devuelve con todas sus letras pasadas a mayusculas
  //si paraTestearDespachador = true responde con tipoMsg = MSGP_RECIBIR_RESPUESTA
  //la aplicacin debe declarar un procedimiento para esperar este mensaje,
  //sino si se pide sincrono la respuesta es inmediata, sino la aplicacion que pide
  //la aplicacin debe declarar un procedimiento para esperar el mensaje MSGR_DELAYED_TO_UPPER_CASE
  MSGP_DELAYED_TO_UPPER_CASE = WM_USER + 5;
  MSGR_DELAYED_TO_UPPER_CASE = WM_USER + 6;

  MSG_LIBERAR_ROBOT_T_C_U_DESPACHADOR = WM_USER + 7;

  ERROR_NO_SE_PUDO_TRAER_EL_COMUNICADO_DESDE_LA_DLL = -7;
  ERROR_NO_SE_PUDO_TRAER_LOS_DATOS_DEL_COMUNICADO_DESDE_LA_DLL = -8;

implementation

end.
