unit uTarea;

interface

uses
  Classes, SysUtils, windows,

  unettopos in '..\..\..\src_libnettopos\libnettopos\unettopos.pas',
  uglobsharedmem in '..\..\..\src_libnettopos\libnettopos\uglobsharedmem.pas',
  unettopostypes in '..\..\..\src_libnettopos\libnettopos\unettopostypes.pas',
  uconstantes_nettopos in '..\..\..\src_libnettopos\libnettopos\uconstantes_nettopos.pas',
  uConstantesDistribuidor in '..\distribuidor\uConstantesDistribuidor.pas',
  uFuncionesAuxiliares in '..\distribuidor\uFuncionesAuxiliares.pas',
  ubuffrw in '..\..\..\src_libnettopos\fctopos\ubuffrw.pas',
  xmatdefs in '..\..\..\..\rchlib\mat\xmatdefs.pas';

type

  { TTarea }

  TTarea=class
  private

    codigoMsg_: integer;    //*Codigo del mensaje para despachar y crear la tarea en los clientes
    freeBufferDatos_: boolean;    //*Indica si le liberar o no el buffer de datos al destruir la tarea

  public

    idNodo_: cardinal;       //*Identificador del nodo al que esta asignada la tarea
    idAplic_: cardinal;    //*Identificador de la aplicacion a la que esta asignada la tarea

    idTarea: cardinal;       //*Identificador de la tarea
    asignada: boolean;       //*Indica si la tarea esta asignada a algun nodo
    resuelta: boolean;       //*Indica si la tarea esta resuelta

    ticsIni:Int64; // Para calculo de performance y para equilibrar tareas.
    ticsFin:Int64; // *** A VER COMO HACER ***

    tambuffDatos_: cardinal; //*Tamano en bytes del buffer de datos
    bufferDatos_: PByte;     //*Buffer de datos

    tambuffResultados_: cardinal; //*Tamano del buffer de resultados
    bufferResultados_: PByte;     //*Buffer de resultados

    constructor Crear(codigoMsg: integer; bufferDatos: PByte;
      tambuffDatos: cardinal; freeBufferDatos: boolean = True);

    //asigna la tarea a un nodo y a una aplicacion
    procedure asignar (idNodo: Cardinal; idAplic:Cardinal);


    //manda a realizar la tarea, dependera del codigo del mensaje que procedimiento se
    //ejecutan sobre los datos de la tarea.
    procedure despacharTarea;

    procedure levantarResultados (p: pointer; nBytes: Integer);


    procedure procesarResultadosEnLinea(p: pointer; nBytes: Integer);virtual;abstract;
    procedure procesarResultadosFinDelPaso;virtual;abstract;

    procedure Destruir;

  end;


implementation

{ TTarea }

constructor TTarea.Crear(codigoMsg: integer; bufferDatos: PByte;
  tambuffDatos: cardinal; freeBufferDatos: boolean);
begin
  freeBufferDatos_ := freeBufferDatos;
  codigoMsg_ := codigoMsg;
  tambuffDatos_ := tambuffDatos;
  bufferDatos_ := bufferDatos;
  asignada := False;
  resuelta := False;
end;

procedure TTarea.asignar(idNodo: Cardinal; idAplic: Cardinal);
begin
  self.idNodo_:=idNodo;
  self.idAplic_:=idAplic;
  self.asignada:=true;
end;

procedure TTarea.despacharTarea;
var
   fc_s:TFichaComunicado;
   timeOutTotal: Integer;
begin
   fc_s.idNodoOrigen:=pm^.idNodoLocal;
   fc_s.idOrigen:=idAplicYo;
   fc_s.idNodoDestino:= idNodo_;
   fc_s.idDestino:=idAplic_;
   fc_s.codigoMsg:=self.codigoMsg_;
   fc_s.idTarea:=self.idTarea;
   if self.bufferDatos_ <> nil then
    begin
      timeOutTotal:= round(fc_s.nBytesDatos*timeOutComsPorByte);
      fc_s.nBytesDatos:=self.tambuffDatos_;
      comunicar(@fc_s, self.bufferDatos_, timeOutTotal);
     end
    else
     begin
      fc_s.nBytesDatos:=0;
      comunicar(@fc_s, nil, timeOUT);
     end;
     QueryPerformanceCounter(ticsIni);
end;

procedure TTarea.levantarResultados(p: pointer; nBytes: Integer);
begin
 Getmem(self.bufferResultados_, nBytes);
 Move(p, self.bufferResultados_, nBytes);
 self.tambuffResultados_:=nBytes;
 self.resuelta:=true;
 QueryPerformanceCounter(ticsFin);
end;


procedure TTarea.Destruir;
begin
  if freeBufferDatos_ then
    if bufferDatos_ <> nil then
    begin
      Dispose(bufferDatos_);
    end;

  if bufferResultados_ <> nil then
    begin
      Dispose(bufferResultados_);
    end;
  self.Free;

end;

end.

