unit uTestTareas;


interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs,

  unettopos in '..\..\..\src_libnettopos\libnettopos\unettopos.pas',
  uglobsharedmem in '..\..\..\src_libnettopos\libnettopos\uglobsharedmem.pas',
  unettopostypes in '..\..\..\src_libnettopos\libnettopos\unettopostypes.pas',
  uconstantes_nettopos in '..\..\..\src_libnettopos\libnettopos\uconstantes_nettopos.pas',
  uConstantesDistribuidor in '..\distribuidor\uConstantesDistribuidor.pas',
  uFuncionesAuxiliares in '..\distribuidor\uFuncionesAuxiliares.pas',
  ubuffrw in '..\..\..\src_libnettopos\fctopos\ubuffrw.pas',
  xmatdefs in '..\..\..\..\rchlib\mat\xmatdefs.pas';

type

  { TDistribuidor }

  TDistribuidor = class(TForm)

  private
    { private declarations }

  public
    { public declarations }



    procedure conectarse;
    function getToposVivos:TDArrOfNodos;


  end;

var
  distribuidor: TDistribuidor;

implementation

{$R *.lfm}

{ TDistribuidor }

procedure TDistribuidor.conectarse;
begin

    inicializar;
    idAplicYo := registrarAplicacion(pchar(self.Name), handle);

    getOLanzarTopoLocal;

end;

function TDistribuidor.getToposVivos: TDArrOfNodos;
var
  id:cardinal;
  i, nVivos: Integer;
  nodosRegistrados, toposVivos: TDArrOfNodos;

begin

 nodosRegistrados := getNodosRegistrados;
 nVivos:=0;
 for i := 0 to Length(nodosRegistrados)-1 do
  begin
   id:= getIdAplicacion(nodosRegistrados[i].idNodo, 'topo');
   if id > 0 then
    begin
     nVivos:=nVivos+1;
     nodosRegistrados[i].idTopo:=id;
     nodosRegistrados[i].estado:=1;
    end
   else
    nodosRegistrados[i].estado:=0;
  end;
 if nVivos <> 0 then
  begin
   SetLength(toposVivos, nVivos);
   for i:= 0 to Length(nodosRegistrados)-1 do
    if nodosRegistrados[i].estado = 1 then
     begin
      nVivos:=nVivos-1;
      toposVivos[nVivos]:=nodosRegistrados[i];
     end
    else
     nodosRegistrados[i].Free;
  end
 else
  raise Exception.Create('getToposVivos: NO hay topos vivos');



end;

end.

