unit utest_tareassincronas;

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Windows, Messages,
  xmatdefs,
  uconstantes_nettopos,
  unettopostypes,
  unettopos, unettoposclientutils;

type

  { TForm1 }

  TForm1 = class(TForm)
    btPost_memoADD: TButton;
    btCall_memoADD: TButton;
    btGetToposRegistrados: TButton;
    eNodoDestino: TEdit;
    eTimeOut: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Memo: TMemo;
    procedure btCall_memoADDClick(Sender: TObject);
    procedure btGetToposRegistradosClick(Sender: TObject);
    procedure btPost_memoADDClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    nodoDestino: cardinal;
    nodos: TDAOfNCardinal;
    procedure msg_respuestaMemoAdd( var Msg: TMessage ); message MSGR_TOPO_MEMO_ADD;
  end; 

var
  Form1: TForm1; 

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  unettoposclientutils.AlFinal;
end;

procedure TForm1.btPost_memoADDClick(Sender: TObject);
begin
  nodoDestino:= strToInt64( eNodoDestino.text);
  post_MemoAdd( nodoDestino, 'Hola topito' );
end;

procedure TForm1.btCall_memoADDClick(Sender: TObject);
var
  res: integer;
begin
  nodoDestino:= strToInt64( eNodoDestino.text);
  res:= call_MemoAdd( nodoDestino, 'Hola topito', StrToInt( eTimeOut.text ) );
  if res > 0 then
    memo.lines.add('Call_MemoADD OK, res = '+IntToStr( res ) )
  else
    memo.lines.add('Call_MemoAdd FALLO!!' );
end;

procedure TForm1.btGetToposRegistradosClick(Sender: TObject);
var
  k: integer;
begin
  nodos:= IIE_NodosRegistrados;
  for k:= 0 to high( nodos ) do
  begin
    memo.lines.add( IntToStr( nodos[k] ) );
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  if not unettoposclientutils.AlInicio( 'test_tareassincronoas', handle ) then
  raise Exception.Create('Fallo inicialización' );
end;


procedure TForm1.msg_respuestaMemoAdd( var Msg: TMessage );

var
  fc: TFichaComunicado;
begin
  if leerFichaComunicado(msg.WParam, @fc) > 0 then
  begin
    if levantarDatosComunicado(msg.WParam, NIL, 0) > 0 then
    begin
      memo.Lines.Add('Comunicar: Respuesta recibida tarea MemoAdd ' + IntToStr(fc.idTarea) + ' OK');
    end
    else
      memo.Lines.Add('Comunicar Fallo: No pude levantar los datos de la respuesta a la tarea MemoAdd ' + IntToStr(fc.idTarea));
  end
  else
    memo.Lines.Add('Comunicar Fallo: No pude levantar la respuesta');
end;


end.

