unit uLibFuncionesComunes;

interface
uses
  uconstantes_nettopos, SysUtils,
{$IFDEF WINDOWS}
  ShellApi, Windows, 
{$ELSE}
  uEmuladorWinIPC, uWinMsgs,
{$ENDIF}
{$IFDEF NETTOPOS_DLL}
  uimportnettopos,
{$ELSE}
  unettopos,
  unettopostypes,
  uglobsharedmem
{$ENDIF};

procedure invertirComunicado(var comunicado: TFichaComunicado);
function lanzarTopoLocal: Cardinal;
function crearComunicado(xIdNodoDestino, xIdDestino: Cardinal;
                         xCodigoMsg: Integer; xlparam: Integer;
                         xIdTarea: Cardinal;
                         xNBytesDatos: Cardinal): TFichaComunicado;

implementation

procedure invertirComunicado(var comunicado: TFichaComunicado);
var
  aux_Swap: Cardinal;
begin
  aux_Swap:= comunicado.idNodoOrigen;
  comunicado.idNodoOrigen:= comunicado.idNodoDestino;
  comunicado.idNodoDestino:= aux_Swap;

  aux_Swap:= comunicado.idOrigen;
  comunicado.idOrigen:= comunicado.idDestino;
  comunicado.idDestino:= aux_Swap;
end;

function lanzarTopoLocal: Cardinal;
var
  idTopo: Cardinal;
  dir : pchar;
  dirAsString: String;
begin
  idTopo:= getIdAplicacion(0, uconstantes_nettopos.AppName_Topo);
  if idTopo = 0 then  //Si no encontre un topo corriendo ejecuto uno
  begin
    dirAsString:= GetCurrentDir;
    GetMem(dir, length(dirAsString) + 1);
    StrPCopy(dir, dirAsString);
{$IFDEF WINDOWS}
    //TODO
    //ver si se puede sacar el 0
    if Shellexecute(0, 'open', uconstantes_nettopos.BinName, nil, dir, SW_SHOW ) <> 0 then
{$ELSE}
    if LanzarApl(uconstantes_nettopos.BinName, []) then
{$ENDIF}
    begin
      sleep(500); //Doy tiempo al topo de registrarse
      idTopo:= getIdAplicacion(0, uconstantes_nettopos.AppName_Topo);
    end;
    FreeMem(dir, length(dirAsString) + 1);
  end;
  result:= idTopo;
end;

function crearComunicado(xIdNodoDestino, xIdDestino: Cardinal;
                         xCodigoMsg: Integer; xlparam: Integer;
                         xIdTarea: Cardinal;
                         xNBytesDatos: Cardinal): TFichaComunicado;
var
  res: TFichaComunicado;
begin
  with res do
  begin
    idNodoOrigen:= getIdNodoLocal;
    idOrigen:= idAplicYo;
    idNodoDestino:= xIdNodoDestino;
    idDestino:= xIdDestino;
    codigoMsg:= xCodigoMsg;
    lParam:= xlparam;
    idTarea:= xIdTarea;
    nBytesDatos:= xNBytesDatos;
  end;
  result:= res;
end;

end.
