unit unettopostypes;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFDEF LINUX}
  SysUtils, sockets, uEmuladorWinIPC,
{$ELSE}
  Windows, SysUtils, ipcthrd, winsock,
{$ENDIF}
urosx;

const
  MAX_N_APLICACIONES = 100;
  MAX_N_PETICIONES = 1000;
  MAX_N_TAREAS_SINCRONAS = MAX_N_APLICACIONES;
//  MAX_SIZE_BUFFER_CHICO = 1024 * 4;//4kB
  MAX_SIZE_BUFFER_CHICO = 1492;

  //Tiempo en dias(punto flotante) tras el cual una ficha de comunicado se considera perdida
  DEF_TIMEOUT_DT = 30.0/(24.0*60.0*60.0);

  MAX_SIZE_BUFFER_GRANDE = 1024*1024;

type

    { TNodo }


    TNodo= packed class
    public
      idNodo: cardinal;
      maquina: string;
      puerto: cardinal;
      ixPoderDeCalculo: cardinal; // indicador de poder de clculo con test
      ixVelocidadDeTransferencia: cardinal; // indicador de velocidad de transf.
      estado: integer; // -1 = ?; 0=down; 1=topo up 2= topo y aplic disponible 3 listo
      idTopo: cardinal;
      constructor Create( IPStr: string; puerto: cardinal; maquina: string );

  end;
  TDArrOfNodos = array of TNodo;
  TLArrOfBytes= packed array[0..1024*1024*1024] of byte;
  PLArrOfBytes= ^TLArrOfBytes;

type
  PFichaComunicado= ^TFichaComunicado;
  TFichaComunicado = packed record
    idNodoOrigen, idOrigen: cardinal;
    idNodoDestino, idDestino: cardinal;
    codigoMsg: integer;
    nBytesDatos: cardinal;
    pdatos: PLArrOfBytes;
    lParam: Integer;
    idTarea: cardinal;
  end;

  TFichaComunicadoRetardado = packed record
    nSecs: integer;
    pfc: PFichaComunicado;
    pdatos: Pointer;
  end;


  TBufferChico= packed array[0..MAX_SIZE_BUFFER_CHICO -1] of byte;
  PBufferChico= ^TBufferChico;

  TFichaAplicacion = packed record
    idAplic : cardinal;
    idNodo: Cardinal;
    nombreAplic: ShortString;
  end;

  PFichaAplicacion = ^TFichaAplicacion;
	TAplicaciones= packed array[1..MAX_N_APLICACIONES] of TFichaAplicacion;
	PAplicaciones = ^TAplicaciones;

	TFichaPeticion = packed record
    idPeticion: cardinal; // nmero secuencial para seguimiento de logs.
    dtInicio: TDateTime;
    dtVencimiento: Double;
    fc: TFichaComunicado;
    bufferDatosChico: TBufferChico;
    {$IFDEF HEAPMANAGER}
    kBloqueLongBuffer: Integer;
    {$ENDIF}
  end;
  PFichaPeticion= ^TFichaPeticion;
  TPeticiones= packed array[1..MAX_N_PETICIONES] of TFichaPeticion;
  PPeticiones = ^TPeticiones;

  TRecFichaTareaSincrona = packed record
    idTareaSincrona: cardinal;
    idTareaOriginal: cardinal;
    idPeticion: cardinal;
  end;

  PRecFichaTareaSincrona = ^TRecFichaTareaSincrona;
  TTareasSincronas= packed array[1..MAX_N_TAREAS_SINCRONAS] of TRecFichaTareaSincrona;

  TFichaConexion = class
    public
      idNodoDestino: Cardinal;
      socket: TSocket;
      timeOut_ms: cardinal;
      Constructor Create(idNodoDestino: Cardinal; socket: TSocket; timeOut_ms: cardinal );
  end;



implementation

{ TNodo }

constructor TNodo.Create(IPStr: string; puerto: cardinal; maquina: string);
begin
  inherited Create;
  Self.idNodo:=  IP4StrToCardinal( IPStr );
  Self.maquina:= maquina;
  Self.puerto:= puerto;
  ixPoderDeCalculo:= 0;
  ixVelocidadDeTransferencia:= 0;
  estado:=-1;
end;

Constructor TFichaConexion.Create(idNodoDestino: Cardinal; socket: TSocket; timeOut_ms: cardinal );
begin
  inherited Create;
  self.idNodoDestino:= idNodoDestino;
  self.socket:= socket;
  self.timeOut_ms:= timeOut_ms;
end;

end.
