unit uTestMsgRetardados;


interface

uses


  Classes, SysUtils,

  uglobsharedmem, unettopostypes, uconstantes_nettopos, unettopos,
  uConstantesSimSEE,

  uMsgRetardados, uFuncionesAuxiliares,

{$IFDEF LINUX}
    pthreads,
    baseunix,
    unix,
    uwinmsgs,
    uemuladorwinipc in '../fctopos/IPC/Linux/uemuladorwinipc.pas';
{$ELSE}
    Forms, Controls, Graphics, Dialogs, StdCtrls,
    Messages;

{$ENDIF}

const

  MSGR_TEST = WM_USER + 1;



type


  { TForm1 }
{$IFDEF LINUX}
  TForm1 = class(TComponent)
{$ELSE}
  TForm1 = class(TForm)
    BsendMsg: TButton;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    eidmsg: TEdit;
    Esecs: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Memo: TMemo;
    procedure BsendMsgClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  {$ENDIF}
  private
    { private declarations }
  public
    { public declarations }

    idAplicYo: Cardinal;
    idMsg : integer;

    {$IFDEF LINUX}

    //Regestro para el manejo de senales del OS
    SActionRec_: SigActionRec;

      recolectar: boolean;
      constructor Create(AOwner: TComponent); reintroduce;
      procedure Free; virtual;
    {$ENDIF}


    procedure msgr_testMsg (var Msg: TMessage); message MSGR_TEST;


  end;

var
  Form1: TForm1;
 // msgsRetardados: TMensajesRetardados;



implementation

{$R *.lfm}

{$IFDEF LINUX}
var
  SActionRec: SigActionRec;

{ Procedimientos agregados para el manejo de señales
del sistema.}
procedure Handler(Sig : Integer); cdecl;
begin
  case Sig of
    SIGALRM:
    begin
      writeln('SIGALRM');
      msgsRetardados.Start;
      exit;
    end;
    SIGINT{, SIGTERM} :
    begin
      writeln('--- recibi SIGINT o SIGTERM ---' );
      Form1.recolectar:= false;
      exit;
    end;
    //  SIGIO: writeln('SIGIO');
  end; { case }
end;

procedure InstallHandlers;
begin
//  writeln('Instalo Handlers, ThreadId= ', GetThreadId);
  with SActionRec do
  begin
    sa_handler:= SigActionHandler(@Handler);
    fpsigemptyset(sa_mask);
    FpSigAddSet(sa_mask, SIGALRM);
    sa_flags:= 0;
  end; { with }
  fpsigaction(SIGINT, @SActionRec, nil);
  fpsigaction(SIGTERM, @SActionRec, nil);
  fpsigaction(SIGALRM, @SActionRec, nil);


end;


constructor TForm1.Create(AOwner: TComponent);
var
   fc: TFichaComunicado;
   i: Integer;

begin

  inherited Create( AOwner );

  inicializar;
  idAplicYo := registrarAplicacion( 'testmsgs' , fpGetPid);

  InstallHandlers;

  FpsigEmptySet(sigs);
  FpSigAddSet(sigs, SIGALRM);
  pthread_sigmask(SIG_SETMASK, @sigs, nil);

  recolectar:= true;

  msgsRetardados:= TMensajesRetardados.Create;

  fc.idNodoOrigen:=pm^.idNodoLocal;
  fc.idOrigen:=idAplicYo;
  fc.idNodoDestino:=pm^.idNodoLocal;
  fc.idDestino:=idAplicYo;

  fc.nBytesDatos:=0;

  fc.codigoMsg:=MSGR_TEST;

  agendar_msgRetardado(fc, 0, 10, true);

end;

procedure TForm1.Free;
begin
 desregistrarAplicacion( idAplicYo );
 finalizar;
 inherited Free;

end;

{$ELSE}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin

  inicializar;

  idAplicYo := registrarAplicacion('test', handle);
  idMsg:=0;

  getOLanzarTopoLocal;


end;

procedure TForm1.FormDestroy(Sender: TObject);
begin

 desregistrarAplicacion( idAplicYo );
 finalizar;
// flag := false;

end;

procedure TForm1.BsendMsgClick(Sender: TObject);
var
   fc: TFichaComunicado;

begin

  fc.idNodoOrigen:=pm^.idNodoLocal;
  fc.idOrigen:= idAplicYo;
  fc.idNodoDestino:=pm^.idNodoLocal;
  fc.idDestino:= idAplicYo;
  fc.codigoMsg:= MSGR_TEST;
  fc.nBytesDatos:=0;
  fc.idTarea:=idMsg;

  agendar_msgRetardado(fc, idMsg, StrToInt(Esecs.Text), CheckBox1.Checked);

  memo.Lines.Add('msg'+IntToStr(idMsg)+' agendado' + TimeToStr(now));

  idMsg:=idMsg + 1;



end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  desagendar_msgRetardado(StrToInt(eidmsg.Text));
  memo.Lines.Add('msg'+eidmsg.Text+' desagendado');
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   fc: TFichaComunicado;

begin

  fc.idNodoOrigen:=pm^.idNodoLocal;
  fc.idOrigen:= idAplicYo;
  fc.idNodoDestino:=pm^.idNodoLocal;
  fc.idDestino:= idAplicYo;
  fc.codigoMsg:= MSGR_TEST;
  fc.nBytesDatos:=0;
  fc.idTarea:=idMsg;

  comunicar(@fc, nil, timeOutComsCte);

end;


{$ENDIF}

procedure TForm1.msgr_testMsg(var Msg: TMessage);
var
   fc: TFichaComunicado;

begin

  if leerFichaComunicado (msg.wParam, @fc) > 0 then
    begin
      levantarDatosComunicado(msg.wParam, nil, 0);
      {$IFDEF LINUX}
       writeln('LLego msg'+IntToStr(fc.idTarea));
      {$ELSE}
       memo.Lines.Add('LLego msg'+IntToStr(fc.idTarea)+' '+ TimeToStr(now));
      {$ENDIF}
    end;
end;

end.

