unit uDatosConexionNodo;

interface

uses
  Classes, SysUtils, uAuxiliares;

const
  strComentario = '//';

type
  TDatosConexionNodo = class
    public
      HostName: ShortString;
      IPaddr: ShortString;
      puertoTopo: Integer;
      comentado: boolean;

      Constructor Create(HostName: ShortString; IPaddr: ShortString; puertoTopo: Integer; comentado: boolean);
      procedure Free;
      Constructor Create_FromStr( linea: string );
      function toStr: string;
  end;

  TListaDatosConexionNodo = class(TList)
    public
      constructor Create_ReadFromText(arch: String);
      procedure WriteToText(arch: String);
      procedure FreeConElemenentos;
      function getDatosConexionByHostName(hostName: ShortString): TDatosConexionNodo;
      function getDatosConexionByIP(ipAddr: ShortString): TDatosConexionNodo;
  end;

implementation

Constructor TDatosConexionNodo.Create(HostName: ShortString; IPaddr: ShortString; puertoTopo: Integer; comentado: boolean);
begin
  inherited Create;
  self.HostName:= AnsiLowerCase(HostName);
  self.IPaddr:= IPaddr;
  self.puertoTopo:= puertoTopo;
  self.comentado:= comentado;
end;

procedure TDatosConexionNodo.Free;
begin
  inherited Free;
end;

constructor TDatosConexionNodo.Create_FromStr( linea: string);
var
  pal: string;
  posComentario: Integer;
begin
  inherited Create;

  //writeln( 'Linea: ', linea );

  pal:= nextPal( linea );
  posComentario:= Pos(strComentario, pal);
  if posComentario <> 1 then
  begin
    comentado:= false;
  end
  else
  begin
    Delete(pal, 1, length(strComentario));
    comentado:= true;
  end;

  //writeln(' ip: ', pal );
  self.IPaddr:= pal;

  pal:= nextPal(  linea );
  //writeln(' puerto: ', pal );
  self.puertoTopo:= StrToInt( pal );

  pal:= nextPal( linea );
  //writeln(' HostName: ', pal );
  self.HostName:= AnsiLowerCase( pal );
end;

function TDatosConexionNodo.toStr: string;
begin
  if comentado then
    result:= '//' + IPaddr + #9 + IntToStr(puertoTopo) + #9 + HostName
  else
    result:= IPaddr + #9 + IntToStr(puertoTopo) + #9 + HostName;
end;

constructor TListaDatosConexionNodo.Create_ReadFromText(arch: String);
var
  f: textfile;
  r: string;
  a: TDatosConexionNodo;

begin
  inherited Create;
  assignfile( f, arch );
  {$I-}
  reset( f );
  {$I+}
  if ioresult <> 0 then
    raise exception.Create('TlistaDatosConexionNodo.Create_ReadFromText, error al intentar leer de: '+arch );

  while not eof( f ) do
  begin
    readln( f, r );
    r:= trim( r );
    if r <> '' then
    begin
      a:= TDatosConexionNodo.Create_FromStr( r );
      add( a );
    end;
  end;
  closefile( f );
end;

procedure TListaDatosConexionNodo.WriteToText(arch: String);
var
  f: textfile;
  i: integer;
begin
  assignfile( f, arch );
  {$I-}
  rewrite( f );
  {$I-}
  if ioresult <> 0 then
    raise exception.Create( 'TListaDatosConexionNodo.WriteToText, no puedo crear archivo: '+arch );

  for i:= 0 to Count - 1 do
    writeln( f, TDatosConexionNodo(items[i]).toStr );
  closefile( f );
end;

procedure TListaDatosConexionNodo.FreeConElemenentos;
var
  i: Integer;
begin
  for i:= 0 to Count - 1 do
    TDatosConexionNodo(items[i]).Free;
  self.Free;
end;

function TListaDatosConexionNodo.getDatosConexionByHostName(hostName: ShortString): TDatosConexionNodo;
var
  i: Integer;
  res: TDatosConexionNodo;
begin
  res:= NIL;
  hostName:= AnsiLowerCase(hostName);
  for i:= 0 to Count - 1 do
    if TDatosConexionNodo(items[i]).HostName = hostName then
    begin
      res:= items[i];
      break;
    end;
  result:= res;
end;

function TListaDatosConexionNodo.getDatosConexionByIP(ipAddr: ShortString): TDatosConexionNodo;
var
  i: Integer;
  res: TDatosConexionNodo;
begin
  res:= NIL;
  for i:= 0 to Count - 1 do
    if TDatosConexionNodo(items[i]).IPaddr = ipAddr then
    begin
      res:= items[i];
      break;
    end;
  result:= res;
end;

end.
