unit ulistaappsconocidas;

interface

uses
  classes, uauxiliares, sysutils;

type
  TDatosApp = class
    public
      nomApp, winBinName, linuxBinName: String;
      Constructor Create(nomApp, winBinName, linuxBinName: String);
      procedure Free;
      Constructor Create_ReadFromStr( linea: string );
      procedure WriteToStr( var linea: string );
  end;

  TListaAppsConocidas= class(TList)
    public
      constructor Create_ReadFromArchi(archi: String);
      procedure WriteToArchi( archi: String);
      procedure FreeConElemenentos;
      function getBinName(nomApp: String): String;
      function getWinBinName(nomApp: String): String;
      function getLinuxBinName(nomApp: String): String;
  end;

implementation

Constructor TDatosApp.Create(nomApp, winBinName, linuxBinName: String);
begin
  inherited Create;
  self.nomApp:= nomApp;
  self.winBinName:= winBinName;
  Self.linuxBinName:= linuxBinName;
end;

procedure TDatosApp.Free;
begin
  inherited Free;
end;

Constructor TDatosApp.Create_ReadFromStr( linea: string );
begin
  inherited Create;
  self.nomApp:= nextPal(linea);
  self.winBinName:= nextPal(linea);
  Self.linuxBinName:= nextPal(linea);
end;

procedure TDatosApp.WriteToStr( var linea: string );
begin
  linea:= nomApp + #9 + winBinName + #9 + linuxBinName;
end;

constructor TListaAppsConocidas.Create_ReadFromArchi(archi: string);
var
  f: textfile;
  a: TDatosApp;
  r: string;
begin
  if not FileExists(archi) then
    raise Exception.Create('TListaAppsConocidas.Create_ReadFromArchi: No se encuentra el archivo de aplicaciones conocidas ' + archi);

  inherited Create;
  assignfile( f, archi );
  {$I-}
  reset(f );
  {$I+}
  if ioresult = 0 then
  begin
    while not eof( f ) do
    begin
      readln( f, r );
      if r = '' then continue; // linea vacia
      if r[1]= '#' then continue; // comentario

      a:= TDatosApp.Create_ReadFromStr( r );
      self.Add(a)
    end;
    closefile( f );
  end
  else
  begin // intento crear el archivo
    writeToArchi( archi );
  end;
end;

procedure TListaAppsConocidas.WriteToArchi(archi: String);
var
  f: textfile;
  i: Integer;
  s: string;
begin
  assignfile( f, archi  );
  {$I-}
  rewrite( f );
  {$I+}
  if ioresult <> 0 then
    raise Exception.Create('ulistaappsconocidas.TlistaAppsConocidas.WriteToArchi('+Archi+') FALLO al intentar crear el archivo.' );

  writeln( f, '# archivo de aplicaciones conocidas cada renglon especifica una aplicacion');
  writeln( f, '# la sitaxis es:  nombreApp winBinName linuxBinName ' );
  writeln( f, '# debiendo comenzar el nombreApp en el primer caracter del renglon. ' );
  for i:= 0 to Count - 1 do
  begin
    TDatosApp(items[i]).WriteToStr(s);
    writeln( f, s );
  end;
  closefile( f );
end;

procedure TListaAppsConocidas.FreeConElemenentos;
var
  i: Integer;
begin
  for i:= 0 to Count - 1 do
    TDatosApp(items[i]).Free;
  self.Free;
end;

function TListaAppsConocidas.getBinName(nomApp: String): String;
begin
{$IFDEF WINDOWS}
  result:= getWinBinName(nomApp);
{$ELSE}
  result:= getLinuxBinName(nomApp);
{$ENDIF}
end;

function TListaAppsConocidas.getWinBinName(nomApp: String): String;
var
  i: Integer;
  res: String;
begin
  res:= '';
  for i:= 0 to Count - 1 do
    if TDatosApp(items[i]).nomApp = nomApp then
    begin
      res:= TDatosApp(items[i]).winBinName;
      break;
    end;
  result:= res;
end;

function TListaAppsConocidas.getLinuxBinName(nomApp: String): String;
var
  i: Integer;
  res: String;
begin
  res:= '';
  for i:= 0 to Count - 1 do
    if TDatosApp(items[i]).nomApp = nomApp then
    begin
      res:= TDatosApp(items[i]).linuxBinName;
      break;
    end;
  result:= res;
end;

end.
